% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataQuery.R
\name{dataQuery}
\alias{dataQuery}
\title{dataQuery}
\usage{
dataQuery(x, y, x.dates, y.dates, time.buffer, spatial.buffer = NULL,
  smooth.fun = NULL)
}
\arguments{
\item{x}{Object of class \emph{RasterStack}, \emph{RasterBrick} or \emph{data.frame}.}

\item{y}{Object of class \emph{SpatialPoints} or \emph{SpatialPointsDataFrame}.}

\item{x.dates}{Object of class \emph{Date} with \emph{x} observation dates.}

\item{y.dates}{Object of class \emph{Date} with \emph{y} observation dates.}

\item{time.buffer}{Two element vector with temporal search buffer (expressed in days).}

\item{spatial.buffer}{Spatial buffer size used to smooth the returned values. The unit depends on the spatial projection.}

\item{smooth.fun}{Smoothing function applied with \emph{spatial.buffer}.}
}
\value{
An object of class \emph{data.frame} with the selected values and their corresponding dates.
}
\description{
Query environmental data for coordinate pairs using the nearest non NA value in time.
}
\details{
{Returns environmental variables from a raster object for a given set of x and y coordinates depending on the
temporal distance between the sample observation date (\emph{y.dates}) and the date on which the environmental data was
collected (\emph{x.dates}). Within the buffer specified by \emph{time.buffer}, the function will search for the nearest
non \emph{NA} value with the shortest temporal distance. The user can adjust \emph{time.buffer} to control which pixels
are considered in this analysis. For example, \emph{time.buffer} can be set to c(30,0) prompting the function to ignore
environmental information acquired after the sample observation date and limit the search to -30 days. If \emph{time.buffer}
is set to null all acquisitions are considered. The user may also provide \emph{spatial.buffer} to spatially smooth the selected
environmental information. In this case, for each sample, the function will consider the neighboring pixels within the selected
acquisition and apply a smoothing function defined by \emph{smooth.fun}. If \emph{smooth.fun} is not specified, a weighted mean
will be returned by default. If \emph{x} is a \emph{data.frame} \emph{spatial.buffer} and \emph{smooth.fun} are ignored and
\emph{x.dates} should refer to each column.}
}
\examples{
{

 require(raster)

 # read raster data
 file <- list.files(system.file('extdata', '', package="rsMove"), 'ndvi.tif', full.names=TRUE)
 r.stk <- stack(file)
 r.stk <- stack(r.stk, r.stk, r.stk) # dummy files for the example

 # read movement data
 data(shortMove)

 # raster dates
 file.name <- names(r.stk)
 x.dates <- as.Date(paste0(substr(file.name, 2, 5), '-',
 substr(file.name, 7, 8), '-', substr(file.name, 10, 11)))

 # sample dates
 y.dates <- as.Date(shortMove@data$date)

 # retrieve remote sensing data for samples
 rsQuery <- dataQuery(r.stk, shortMove, x.dates, y.dates, c(10,10))

}

}
\seealso{
\code{\link{sampleMove}} \code{\link{backSample}}
}
