% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poly2sample.R
\name{poly2sample}
\alias{poly2sample}
\title{poly2sample}
\usage{
poly2sample(x, y, min.cover = 1)
}
\arguments{
\item{x}{Object of class \emph{SpatialPolygons} or \emph{SpatialPolygonDataFrame}.}

\item{y}{A raster object or a numeric element.}

\item{min.cover}{Minimum percent a pixel should be covered by a polygon for sampling (1-100). Default is 1.}
}
\value{
A \emph{SpatialPointsDataFrame} with sampled pixels reporting on polygon percent coverage.
}
\description{
{Converts a raster grid to points depending on how much each pixel is covered by a polygon.}
}
\details{
{\emph{poly2Sample} extends on the \code{\link[raster]{rasterize}} function from the raster package making
it more efficient over large areas and converting its output into point samples rather than a raster object. For each
polygon in (\emph{"x"}), \emph{poly2sample} extracts the overlapping pixels of a reference grid. Then, for each pixel,
the function estimates the percentage of it that is covered by the reference polygon. Finally, the function extracts
coordinate pairs for pixels that has a percent coverage equal to or greater than \emph{min.cover}. If \emph{y} is a
raster object, the function will use it as a reference  grid. If \emph{y} is a numeric element, the function will build
a raster from the extent of \emph{x} and a resolution equal to \emph{y}.}
}
\examples{
{

 require(raster)

 # load example probability image
 file <- system.file('extdata', 'probabilities.tif', package="rsMove")
 img <- raster(file)

 # load area of interest
 file <- system.file('extdata', 'roi.shp', package="rsMove")
 roi <- shapefile(file)

 # extract samples
 samples <- poly2sample(roi, img, min.cover=50)

}
}
\seealso{
\code{\link{dataQuery}} \code{\link{imgInt}}
}
