% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkOverlap.R
\name{checkOverlap}
\alias{checkOverlap}
\title{checkOverlap}
\usage{
checkOverlap(x, y)
}
\arguments{
\item{x}{A spatial object.}

\item{y}{A spatial object.}
}
\value{
A two element numeric \emph{vector}.
}
\description{
Reports on how much two spatial objects overlap.
}
\details{
{Uses \link[raster]{intersect} to report on the percentage of the area
of \emph{x} and \emph{y} that coincides with their common spatial overlap.}
}
\examples{
{

 require(raster)

 # load example probability image
 file <- system.file('extdata', 'probabilities.tif', package="rsMove")
 img <- raster(file)

 # load area of interest
 file <- system.file('extdata', 'roi.shp', package="rsMove")
 roi <- shapefile(file)

 # extract samples
 checkOverlap(img, roi)

}
}
