% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initial_split.R
\name{initial_split}
\alias{initial_split}
\alias{training}
\alias{testing}
\title{Simple Training/Test Set Splitting}
\usage{
initial_split(data, prop = 3/4, strata = NULL, ...)

training(x)

testing(x)
}
\arguments{
\item{data}{A data frame.}

\item{prop}{The proportion of data to be retained for modeling/analysis.}

\item{strata}{A variable that is used to conduct stratified sampling to create the resamples.}

\item{...}{Not currently used.}

\item{x}{An `rsplit` object produced by `initial_split`}
}
\value{
An `rset` object that can be used with the `training` and `testing` functions to extract the data in each split.
}
\description{
`initial_split` creates a single binary split of the data 
 into a training set and testing set. `training` and
 `testing` are used to extract the resulting data.
}
\details{
The `strata` argument causes the random sampling to be conducted *within the stratification variable*. The can help ensure that the number of data points in the training data is equivalent to the proportions in the original data set.
}
\examples{
set.seed(1353)
car_split <- mc_cv(mtcars)
train_data <- training(car_split)
test_data <- testing(car_split) 
}
