% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inner_split.R
\name{inner_split}
\alias{inner_split}
\alias{inner_split.mc_split}
\alias{inner_split.group_mc_split}
\alias{inner_split.vfold_split}
\alias{inner_split.group_vfold_split}
\alias{inner_split.boot_split}
\alias{inner_split.group_boot_split}
\alias{inner_split.val_split}
\alias{inner_split.group_val_split}
\alias{inner_split.time_val_split}
\alias{inner_split.clustering_split}
\alias{inner_split.apparent_split}
\title{Inner split of the analysis set for fitting a post-processor}
\usage{
inner_split(x, ...)

\method{inner_split}{mc_split}(x, split_args, ...)

\method{inner_split}{group_mc_split}(x, split_args, ...)

\method{inner_split}{vfold_split}(x, split_args, ...)

\method{inner_split}{group_vfold_split}(x, split_args, ...)

\method{inner_split}{boot_split}(x, split_args, ...)

\method{inner_split}{group_boot_split}(x, split_args, ...)

\method{inner_split}{val_split}(x, split_args, ...)

\method{inner_split}{group_val_split}(x, split_args, ...)

\method{inner_split}{time_val_split}(x, split_args, ...)

\method{inner_split}{clustering_split}(x, split_args, ...)

\method{inner_split}{apparent_split}(x, ...)
}
\arguments{
\item{x}{An \code{rsplit} object.}

\item{...}{Not currently used.}

\item{split_args}{A list of arguments to be used for the inner split.}
}
\value{
An \code{rsplit} object.
}
\description{
Inner split of the analysis set for fitting a post-processor
}
\details{
\code{rsplit} objects live most commonly inside of an \code{rset} object. The
\code{split_args} argument can be the output of \code{\link[=.get_split_args]{.get_split_args()}} on that
corresponding \code{rset} object, even if some of the arguments used to create the
\code{rset} object are not needed for the inner split.
\itemize{
\item For \code{mc_split} and \code{group_mc_split} objects, \code{inner_split()} will ignore
\code{split_args$times}.
\item For \code{vfold_split} and \code{group_vfold_split} objects, it will ignore
\code{split_args$times} and \code{split_args$repeats}. \code{split_args$v} will be used to
set \code{split_args$prop} to \code{1 - 1/v} if \code{prop} is not already set and otherwise
ignored. The method for \code{group_vfold_split} will always use
\code{split_args$balance = NULL}.
\item For \code{boot_split} and \code{group_boot_split} objects, it will ignore
\code{split_args$times}.
\item For \code{val_split}, \code{group_val_split}, and \code{time_val_split} objects, it will
interpret a length-2 \code{split_args$prop} as a ratio between the training and
validation sets and split into inner analysis and inner assessment set in
the same ratio. If \code{split_args$prop} is a single value, it will be used as
the proportion of the inner analysis set.
\item For \code{clustering_split} objects, it will ignore \code{split_args$repeats}.
}
}
\keyword{internal}
