% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extent_crs.R, R/records.R, R/rtoi.R,
%   R/variables.R
\name{show,extent_crs-method}
\alias{show,extent_crs-method}
\alias{show}
\alias{show,records-method}
\alias{show,rtoi-method}
\alias{show,rtoi}
\alias{show,variables-method}
\alias{show,records}
\title{Show an Object}
\usage{
\S4method{show}{extent_crs}(object)

\S4method{show}{records}(object)

\S4method{show}{rtoi}(object)

\S4method{show}{variables}(object)
}
\arguments{
\item{object}{Any R object}
}
\value{
show returns an invisible NULL.
}
\description{
Display the object, by printing, plotting or whatever suits its class. This
function exists to be specialized by methods.
The default method calls showDefault.
}
\examples{
\dontrun{
## load example rtoi
file.copy(from=system.file("ex/Navarre",package="rsat"),
         to=tempdir(),
         recursive = TRUE)

navarre <- read_rtoi(file.path(tempdir(),"Navarre"))

## The method will now be used for automatic printing of navarre
navarre

## get records
rcds <- records(navarre)

rcds
}
}
