% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/similarity_coeff.R
\name{similarity_coeff}
\alias{similarity_coeff}
\title{similarity_coeff}
\usage{
similarity_coeff(
  set1,
  set2,
  setfull = NULL,
  coeff = c("jaccard", "braun", "dice", "hamann", "kappa", "kulczynski", "ochiai",
    "phi", "russelrao", "matching", "simpson", "sneath", "tanimoto", "yule")
)
}
\arguments{
\item{set1}{vector: elements to compare}

\item{set2}{vector: elements to compare}

\item{setfull}{vector: elements to compare (default: \code{NULL})}

\item{coeff}{character: coefficient to compute (default: \code{"jaccard"}), abbreviations can be used}
}
\value{
a numeric similarity coefficient
}
\description{
Computes a similarity coefficient based on the unique elements \code{set1} and \code{set2}
in relation to \code{setfull}. If \code{setfull} is \code{NULL} then \code{setfull} is set
to \code{unique(c(set1, set2))}. For more details, see the vignette \code{vignette("rscc")}.
}
\examples{
s1 <- 1:3
s2 <- 1:5
similarity_coeff(s1, s2)
s1 <- letters[1:3]
s2 <- LETTERS[1:5]
similarity_coeff(s1, s2)
}
