% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_journal_info.R
\name{get_journal_info}
\alias{get_journal_info}
\title{Scrape the description of a journal hosted on Scielo}
\usage{
get_journal_info(journal_id)
}
\arguments{
\item{journal_id}{a character vector with the ID of the journal hosted on
Scielo (the \code{get_journal_id} function can be used to find a journal's ID
from its URL).}
}
\value{
The function returns a \code{tibble} with the journal's description.
}
\description{
\code{get_journal_info()} scrapes the description (publisher, issn, and mission)
 information of a journal hosted on Scielo.
}
\note{
Sometimes, the Scielo website is offline for maintaince,
in which cases this function will not work (i.e., users will get HTML status
different from the usual 200 OK).
}
\examples{
\donttest{
journal_info <- get_journal_info(journal_id = "1981-3821")
}
}
