% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applications.R
\name{applications}
\alias{applications}
\title{List Deployed Applications}
\usage{
applications(account = NULL, server = NULL)
}
\arguments{
\item{account}{Account name. If a single account is registered on the system
then this parameter can be omitted.}

\item{server}{Server name. Required only if you use the same account name on
multiple servers.}
}
\value{
Returns a data frame with the following columns:
\tabular{ll}{
\code{name} \tab Name of application \cr
\code{url} \tab URL where application can be accessed\cr
\code{config_url} \tab URL where application can be configured\cr
\code{status} \tab Current status of application. Valid values are
\code{pending}, \code{deploying}, \code{running}, \code{terminating}, and
\code{terminated}.
}
}
\description{
List all applications currently deployed for a given account.
}
\note{
To register an account you call the \code{\link[=setAccountInfo]{setAccountInfo()}} function.
}
\examples{
\dontrun{

# list all applications for the default account
applications()

# list all applications for a specific account
applications("myaccount")

# view the list of applications in the data viewer
View(applications())
}
}
\seealso{
\code{\link[=deployApp]{deployApp()}}, \code{\link[=terminateApp]{terminateApp()}}

Other Deployment functions: \code{\link{deployAPI}},
  \code{\link{deployApp}}, \code{\link{deployDoc}},
  \code{\link{deploySite}}, \code{\link{deployTFModel}}
}
\concept{Deployment functions}
