% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extendr-wrappers.R
\name{is_convex}
\alias{is_convex}
\alias{is_ccw_convex}
\alias{is_cw_convex}
\alias{is_strictly_convex}
\alias{is_strictly_ccw_convex}
\alias{is_strictly_cw_convex}
\title{Determine the Convexity of a LineString}
\usage{
is_convex(x)

is_ccw_convex(x)

is_cw_convex(x)

is_strictly_convex(x)

is_strictly_ccw_convex(x)

is_strictly_cw_convex(x)
}
\arguments{
\item{x}{an object of class \code{rs_LINESTRING}

See \href{https://docs.rs/geo/latest/geo/algorithm/is_convex/trait.IsConvex.html}{\code{geo} docs for further details}}
}
\value{
a logical vector
}
\description{
For a given \code{rs_LINESTRING} vector, test its convexity. Convexity can be tested
strictly or strongly, as well as based on winding.
}
\examples{
lns <- geom_linestring(
    1:20,
    runif(20, -5, 5),
    rep.int(1:5, 4)
  )
  
is_convex(lns)
is_cw_convex(lns)
is_ccw_convex(lns)
is_strictly_convex(lns)
is_strictly_cw_convex(lns)
is_strictly_ccw_convex(lns)
}
