% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_and_sign.R
\name{default_query_function}
\alias{default_query_function}
\title{Query a STAC API using a specific spatiotemporal area of interest}
\usage{
default_query_function(
  bbox,
  stac_source,
  collection,
  start_date,
  end_date,
  limit,
  ...
)
}
\arguments{
\item{bbox}{An sfc object representing the spatial bounding box of your area
of interest. This must be in EPSG:4326 coordinates (and, if this function is
called from within \code{get_stac_data()}, it will be)}

\item{stac_source}{Character of length 1: the STAC URL to download
imagery from.}

\item{collection}{Character of length 1: the STAC collection to download
images from.}

\item{start_date, end_date}{Character strings of length 1 representing the
boundaries of your temporal range of interest, in RFC-3339 format. Set either
argument to \code{..} to use an open interval; set \code{start_date} to \code{NULL} to not
pass a temporal range of interest (which may cause errors with some APIs). If
this function is called from within \code{get_stac_data()}, the inputs to
\code{start_date} and \code{end_date} will have already been processed to try and force
RFC-3339 compliance.}

\item{limit}{an \code{integer} defining the maximum number of results
to return. If not informed, it defaults to the service implementation.}

\item{...}{Ignored by this function. Arguments passed to \code{get_stac_data()}
via \code{...} will be available (unchanged) in this function}
}
\value{
A StacItemCollection object.
}
\description{
This function is the default method used to retrieve lists of items to
download for all the collections and endpoints supported by rsi. It will
likely work for any other STAC APIs of interest.
}
\details{
You can pass your own query functions to \code{get_stac_data()} and its variants.
This is the best way to perform more complex queries, for instance if you
need to provide authentication to get the list of items (not just the assets)
available for your AOI, or to perform cloud filtering prior to downloading
assets.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
aoi <- sf::st_point(c(-74.912131, 44.080410))
aoi <- sf::st_set_crs(sf::st_sfc(aoi), 4326)
aoi <- sf::st_buffer(sf::st_transform(aoi, 5070), 100)

landsat_image <- get_landsat_imagery(
  aoi,
  start_date = "2022-06-01",
  end_date = "2022-08-30",
  query_function = default_query_function
)
\dontshow{\}) # examplesIf}
}
