% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectral_indices.R
\name{spectral_indices}
\alias{spectral_indices}
\title{Get a data frame of spectral indices}
\source{
\url{https://github.com/awesome-spectral-indices/awesome-spectral-indices}
}
\usage{
spectral_indices(
  ...,
  url = spectral_indices_url(),
  download_indices = NULL,
  update_cache = NULL
)
}
\arguments{
\item{...}{These dots are for future extensions and must be empty.}

\item{url}{The URL to download spectral indices from. If the option \code{rsi_url}
is set, that value will be used; otherwise, if the environment variable
\code{rsi_url} is set, that value will be used; otherwise, the list at
https://github.com/awesome-spectral-indices/awesome-spectral-indices will
be used.}

\item{download_indices}{Logical: should this function download indices? If
\code{NULL}, this function will only download indices if the cache will be
updated. If \code{TRUE}, this function will attempt to download indices no matter
what. If \code{FALSE}, either cached or package indices will be used.}

\item{update_cache}{Logical: should cached indices be updated? If \code{NULL},
cached values will be updated if the cache is older than a day. If \code{TRUE},
the cache will be updated, if \code{FALSE} it will not.}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with nine columns, containing information about spectral indices.
}
\description{
This function returns a data frame of spectral indices, from the
\code{awesome-spectral-indices} repository.
}
\examples{
spectral_indices()

}
