% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{filter_platforms}
\alias{filter_platforms}
\alias{filter_bands}
\title{Filter indices based on (relatively) complicated fields}
\usage{
filter_platforms(
  indices = spectral_indices(),
  platforms = unique(unlist(spectral_indices(download_indices = FALSE, update_cache =
    FALSE)$platforms)),
  operand = c("all", "any")
)

filter_bands(
  indices = spectral_indices(),
  bands = unique(unlist(spectral_indices(download_indices = FALSE, update_cache =
    FALSE)$bands)),
  operand = c("all", "any"),
  type = c("filter", "search")
)
}
\arguments{
\item{indices}{The data frame to filter. Must contain the relevant column.}

\item{platforms, bands}{Names of the instruments (for \code{platforms}) or spectra
(for \code{bands}) indices must contain.}

\item{operand}{A function defining how to apply this filter.
For instance, \code{operand = all} means that the index must contain all the
\code{platforms} or \code{bands} provided, while \code{operand = any} means that the index
must contain at least one of the \code{platforms} or \code{bands} provided.}

\item{type}{What type of query is this? If \code{filter}, then indices are
returned if all/any the bands they use (depending on \code{operand}) are in
\code{bands}. If \code{search}, then indices are returned if all/any of \code{bands} are in
the bands they use.}
}
\value{
A filtered version of \code{indices}.
}
\description{
Filter indices based on (relatively) complicated fields
}
\examples{
filter_platforms(platforms = "Sentinel-2")
filter_platforms(platforms = c("Landsat-OLI", "Sentinel-2"))
filter_bands(bands = c("R", "N"), operand = any)

}
