% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dropbig.multisimsum.R
\name{dropbig.multisimsum}
\alias{dropbig.multisimsum}
\title{Return observations dropped by simsum}
\usage{
\method{dropbig}{multisimsum}(x, ...)
}
\arguments{
\item{x}{An object of class \code{multisimsum}.}

\item{...}{Ignored.}
}
\value{
An object of class \code{dropbig.multisimsum} if \code{dropbig} was set to \code{TRUE} when calling \code{multisimsum}, \code{NULL} otherwise. It contains two slots: \code{big_estvarname} and \code{big_se}. Both slots consist in the portion of the original data that was identified to have estimated values or standard errors exceeding the limits defined by \code{max} and \code{semax}.
}
\description{
\code{dropbig.multisimsum} returns observations dropped by simsum while computing summary statistics for a simulation study.
}
\details{
dropbig.multisimsum
}
\examples{
data(frailty)
ms <- multisimsum(data = frailty, par = "par", true = c(trt = -0.50,
   fv = 0.75), estvarname = "b", se = "se", methodvar = "model",
   by = "fv_dist", dropbig = TRUE, max = 6, semax = 3)
dropbig(ms)
}
\seealso{
\code{\link[=multisimsum]{multisimsum()}}, \code{\link[=print.dropbig.multisimsum]{print.dropbig.multisimsum()}}
}
