% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{tt}
\alias{tt}
\title{Example of a simulation study on the t-test}
\format{
A data frame with 4,000 rows and 8 variables:
\itemize{
\item \code{diff} The difference in mean between groups estimated by the t-test;
\item \code{se} Standard error of the estimated difference;
\item \code{lower}, \code{upper} Confidence interval for the difference in mean as reported by the t-test;
\item \code{df} The number of degrees of freedom assumed by the t-test;
\item \code{repno} Identifies each replication, between 1 and 500;
\item \code{dgm} Identifies each data-generating mechanism: 1 corresponds to normal data with equal variance between the groups, 2 is normal data with unequal variance, 3 and 4 are skewed data (simulated from a Gamma distribution) with equal and unequal variance between groups, respectively;
\item \code{method} Analysis method: 1 represents the t-test with pooled variance, while 2 represents the t-test with unpooled variance.
}
}
\usage{
tt
}
\description{
A dataset from a simulation study with 4 data-generating mechanisms, useful to illustrate custom input of confidence intervals to calculate coverage probability.
This simulation study aims to compare the t-test assuming pooled or unpooled variance in violation (or not) of the t-test assumptions: normality of data, and equality (or not) or variance between groups.
The true value of the difference between groups is -1.
}
\note{
Further details on this simulation study can be found in the R script used to generate this dataset, available on GitHub: \url{https://github.com/ellessenne/rsimsum/blob/master/data-raw/tt-data.R}
}
\examples{
data("tt", package = "rsimsum")
}
\keyword{datasets}
