% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sinaica_station_data.R
\name{sinaica_station_data}
\alias{sinaica_station_data}
\title{Get air quality data from a single measuring station}
\usage{
sinaica_station_data(station_id, parameter, start_date, end_date,
  type = "Crude", remove_extremes = FALSE)
}
\arguments{
\item{station_id}{the numeric code corresponding to each station. See
\code{\link{stations_sinaica}} for a list of stations and their ids.}

\item{parameter}{type of parameter to download
\itemize{
\item{"BEN"}{ - Benceno}
\item{"CH4"}{ - Metano}
\item{"CN"}{ - Carbono negro}
\item{"CO"}{ - Monóxido de carbono}
\item{"CO2"}{ - Dióxido de carbono}
\item{"DV"}{ - Dirección del viento}
\item{"H2S"}{ - Acido Sulfhídrico}
\item{"HCNM"}{ - Hidrocarburos no metánicos}
\item{"HCT"}{ - Hidrocarburos Totales}
\item{"HR"}{ - Humedad relativa}
\item{"HRI"}{ - Humedad relativa interior}
\item{"IUV"}{ - Índice de radiación ultravioleta}
\item{"NO"}{ - Óxido nítrico}
\item{"NO2"}{ - Dióxido de nitrógeno}
\item{"NOx"}{ - Óxidos de nitrógeno}
\item{"O3"}{ - Ozono}
\item{"PB"}{ - Presión Barométrica}
\item{"PM10"}{ - Partículas menores a 10 micras}
\item{"PM2.5"}{ - Partículas menores a 2.5 micras}
\item{"PP"}{ - Precipitación pluvial}
\item{"PST"}{ - Partículas Suspendidas totales}
\item{"RS"}{ - Radiación solar}
\item{"SO2"}{ - Dióxido de azufre}
\item{"TMP"}{ - Temperatura}
\item{"TMPI"}{ - Temperatura interior}
\item{"UVA"}{ - Radiación ultravioleta A}
\item{"VV"}{ - Radiación ultravioleta B}
\item{"XIL"}{ - Xileno}
}}

\item{start_date}{start of range in YYYY-MM-DD format}

\item{end_date}{end of range from which to download data in YYYY-MM-DD format}

\item{type}{The type of data to download. One of the following:
\itemize{
\item{"Crude"}{ - Crude data that has not been validated}
\item{"Validated"}{ - data which has undergone a validation process during which
it was cleaned, verified, and validated}
\item{"Manual"}{ - Manually collected data that is sent to an external
lab for analysis (may no be collected daily). Mostly used for suspend particles collected by
pushing air through a filter which is later sent to a lab to be weighted}
}}

\item{remove_extremes}{whether to remove extreme values. For O3 all values above .2 are set to NA,
for PM10 those above 600, for PM2.5 above 175, for NO2 above .21, for SO2 above .2, and for CO
above 15. This is done so that the values match exactly those of the SINAICA website, but it is
recommended that you use a more complicated statistical procedure to remove outliers.}
}
\value{
data.frame with air quality data. Care should be taken when working with hourly data since
each station has their own timezone (available in the \code{\link{stations_sinaica}} data.frame)
and some stations reported the timezome in which they are located erroneously.
}
\description{
Download data from a single station by specifying a parameter and a date range
}
\examples{
stations_sinaica[which(stations_sinaica$station_name == "Xalostoc"), 1:5]
df <- sinaica_station_data(271, "O3", "2015-09-11", "2015-09-11", "Crude")
head(df)

}
\seealso{
Crude data comes from \url{https://sinaica.inecc.gob.mx/data.php},
validated data from \url{https://sinaica.inecc.gob.mx/data.php?tipo=V}, and
manual data from \url{https://sinaica.inecc.gob.mx/data.php?tipo=M}
}
