% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/privates.R
\name{.nodesExists}
\alias{.nodesExists}
\title{Node Inclusion Checker}
\usage{
.nodesExists(g, f)
}
\arguments{
\item{g}{The original graph from which the attributes need to be extracted. This cannot be a G*,
and it must have at least one attribute, besides the \code{from} and \code{to} columns.}

\item{f}{The set of forbidden paths, written as a data frame. Each row represents a path
as a sequence of nodes. Each row may be of different size, filling the empty cells with
\code{NA}. All nodes involved must be part of \code{g}, and no forbidden path can be of
size 2. This is because the latter is thought as an arc that should not exist in
the first place.}
}
\value{
\code{TRUE} if all nodes in \code{f} are present in the graph. Otherwise,
   it returns \code{FALSE}.
}
\description{
Given a graph \code{g}, and a data frame of forbidden paths \code{f}, the function
   checks that all nodes used on \code{f} are also present on the graph.
}
\details{
Private function that cannot be used by the package's end-users.
}
\seealso{
Other Private Functions: \code{\link{.comb}},
  \code{\link{.get_arc_attributes}},
  \code{\link{.hasSubpaths}}
}
\concept{Private Functions}
\keyword{internal}
