% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-functions.R
\name{GRIMMER_test}
\alias{GRIMMER_test}
\title{GRIMMER test for standard deviation}
\usage{
GRIMMER_test(
  mean,
  sd,
  n_obs,
  m_prec = NULL,
  sd_prec = NULL,
  n_items = 1,
  min_val = NULL,
  max_val = NULL
)
}
\arguments{
\item{mean}{The mean of the distribution}

\item{sd}{The standard deviation of the distribution}

\item{n_obs}{The number of observations (sample size)}

\item{m_prec}{The precision of the mean, as number of digits after the decimal point.
If not provided, taken based on the significant digits of \code{mean} - so only needed if reported mean ends in 0}

\item{sd_prec}{The precision of the standard deviation, again only needed if
reported standard deviation ends in 0.}

\item{n_items}{Number of items in scale, if distribution represents scale averages.
Defaults to 1, which represents any single-item measure.}

\item{min_val}{(Optional) Scale minimum. If provided alongside max_val, the function checks whether the SD is consistent with that range.}

\item{max_val}{(Optional) Scale maximum.}
}
\value{
Logical TRUE/FALSE indicating whether given standard deviation is possible, given the other parameters
}
\description{
This function tests whether a given standard deviation (with a specific precision)
can result from a sample of a given size based on integer responses to one or more
items. The test was first proposed by \href{https://peerj.com/preprints/2400/}{Anaya (2016)}; here, the algorithm
developed by \href{https://aurelienallard.netlify.app/post/anaytic-grimmer-possibility-standard-deviations/}{Allard (2018)} is used.
Note that it is presently \emph{only implemented for single-item measures}.
}
\examples{
# A sample of 18 integers with mean 3.44 cannot have an SD of 2.47. This is shown by
GRIMMER_test(mean = 3.44, sd = 2.47, n_obs = 18)


}
\references{
\insertRef{anaya2016grimmer}{rsprite2}
}
