% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print}
\alias{print}
\alias{print.RSTACQuery}
\alias{print.STACCatalog}
\alias{print.STACCollectionList}
\alias{print.STACCollection}
\alias{print.STACItemCollection}
\alias{print.STACItem}
\title{Printing functions}
\usage{
\method{print}{RSTACQuery}(x, ...)

\method{print}{STACCatalog}(x, ...)

\method{print}{STACCollectionList}(x, n = 10, ...)

\method{print}{STACCollection}(x, ...)

\method{print}{STACItemCollection}(x, n = 10, ..., tail = FALSE)

\method{print}{STACItem}(x, ...)
}
\arguments{
\item{x}{either a \code{RSTACQuery} object expressing a STAC query
criteria or any \code{RSTACDocument}.}

\item{...}{other parameters passed in the functions.}

\item{n}{number of lines to view on each object. Each object has its own type
of truncation in lines. In the \code{stac_collection} object, by default, 10
links will be shown, but if the object has less than 20 collections, all
the collections will be displayed. In \code{STACItemCollection}, by default,
10 features will be shown. If you want to show all lines of a rstac object,
use `n = Inf`.}

\item{tail}{To show the last lines of an object.}
}
\description{
The print function covers all objects in the rstac package:
\itemize{
  \item \code{\link{stac}}: Returns a \code{STACCatalog} document in
   \code{/stac} (V0.8.0 or below) or \code{/} (V0.9.0 or above) endpoint.
  \item \code{\link{stac_search}}: Returns a \code{STACItemCollection}
   document in \code{/stac/search} (V0.8.0 or below) or
   \code{/search} (V0.9.0 or above)  endpoint with a group of Items matching
   the provided search predicates.
  \item \code{\link{collections}}: Return a \code{STACCollectionList}
  document by listing of collections contained in the catalog in
  \code{/collections} endpoint and in \code{/collections/\{collectionId\}}
  endpoint return a single \code{STACCollection} document.
  \item \code{\link{items}}: Return a \code{STACItemCollection} document in
  \code{/collections/\{collectionId\}/items} and a \code{STACItem} document
  in \code{/collections/\{collectionId\}/items/\{itemId\}} WFS3 endpoints.
 }

The rstac package objects visualization is based on \strong{Markdown}, a
 lightweight markup language, so you can paste the output into any
 \strong{Markdown} editor for a better visualization.

For printing use the \code{print()} function directly, since the package has
 a generic implementation for its objects. For console output control, you
 have the option to determine how many items you want to see through the
 \code{n} in \code{print} objects parameters, the following objects have the
 \code{n} parameter:
 \itemize{
  \item \code{\link{items}}
  \item \code{\link{collections}}
  \item \code{\link{stac}}
 }
}
\examples{
\donttest{
# STACItemCollection object
stac_item_collection <-
  stac("http://brazildatacube.dpi.inpe.br/stac/") \%>\%
  stac_search(collections = "CB4_64_16D_STK-1",
         bbox = c(-47.02148, -12.98314, -42.53906, -17.35063),
         limit = 15) \%>\%
  get_request()

print(stac_item_collection, n = 10)

# STACCollectionList object
stac_collection <-
    stac("http://brazildatacube.dpi.inpe.br/stac/") \%>\%
    collections() \%>\%
    get_request()

print(stac_collection, n = 5)

# RSTACQuery object
obj_rstac <- stac("http://brazildatacube.dpi.inpe.br/stac/")

print(obj_rstac)
}
}
\seealso{
\code{\link{stac}} \code{\link{stac_search}} \code{\link{collections}}
\code{\link{items}}
}
