% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loo-prediction.R
\name{loo_predict.stanreg}
\alias{loo_linpred}
\alias{loo_linpred.stanreg}
\alias{loo_predict}
\alias{loo_predict.stanreg}
\alias{loo_predictive_interval}
\alias{loo_predictive_interval.stanreg}
\title{Compute weighted expectations using LOO}
\usage{
\method{loo_predict}{stanreg}(object, type = c("mean", "var", "quantile"),
  probs = 0.5, ..., lw)

\method{loo_linpred}{stanreg}(object, type = c("mean", "var", "quantile"),
  probs = 0.5, transform = FALSE, ..., lw)

\method{loo_predictive_interval}{stanreg}(object, prob = 0.9, ..., lw)
}
\arguments{
\item{object}{A fitted model object returned by one of the 
\pkg{rstanarm} modeling functions. See \code{\link{stanreg-objects}}.}

\item{type}{The type of expectation to compute. The options are
\code{"mean"}, \code{"var"} (variance), and \code{"quantile"}.}

\item{probs}{A vector of probabilities. Ignored unless \code{type} is
\code{"quantile"}.}

\item{...}{Optional arguments passed to \code{\link[loo]{psislw}}. If 
\code{lw} is specified these arguments are ignored.}

\item{lw}{An optional matrix of (smoothed) log-weights. If \code{lw} is 
missing then \code{\link[loo]{psislw}} is executed internally, which may be
time consuming for models fit to very large datasets.}

\item{transform}{Passed to \code{\link{posterior_linpred}}.}

\item{prob}{For \code{loo_predictive_interval}, a scalar in \eqn{(0,1)}
indicating the desired probability mass to include in the intervals. The
default is \code{prob=0.9} (\eqn{90}\% intervals).}
}
\value{
\code{loo_predict} and \code{loo_linpred} return a vector with one 
  element per observation. The only exception is if \code{type="quantile"} 
  and \code{length(probs) >= 2}, in which case a separate vector for each 
  element of \code{probs} is computed and they are returned in a matrix with 
  \code{length(probs)} rows and one column per observation.
  
  \code{loo_predictive_interval} returns a matrix with one row per 
  observation and two columns (like \code{\link{predictive_interval}}). 
  \code{loo_predictive_interval(..., prob = p)} is equivalent to 
  \code{loo_predict(..., type = "quantile", probs = c(a, 1-a))} with 
  \code{a = (1 - p)/2}, except it transposes the result and adds informative 
  column names.
}
\description{
These functions are wrappers around the \code{\link[loo]{E_loo}} function 
(\pkg{loo} package).
}
\examples{
\dontrun{
if (!exists("example_model")) example(example_model)
head(loo_predictive_interval(example_model, prob = 0.8, cores = 2))

# optionally, log-weights can be pre-computed and reused
psis <- loo::psislw(-log_lik(example_model), cores = 2)
loo_predictive_interval(example_model, prob = 0.8, lw = psis$lw_smooth)
loo_predict(example_model, type = "var", lw = psis$lw_smooth)
}

}

