% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collect.R
\name{collect_simulations}
\alias{collect_simulations}
\title{Group stansim objects into a collection}
\usage{
collect_simulations(collection_name, object, ...)
}
\arguments{
\item{collection_name}{A name attached to the \code{stansim_collection}
object to help identify it. It is strongly recommended that an informative
and unique name is assigned.}

\item{object}{An object of class \code{stansim_simulation} or
\code{stansim_collection}. Must be provided.}

\item{...}{Any further \code{stansim_simulation} or \code{stansim_collection}
objects to be grouped into a single \code{stansim_collection} object.}
}
\value{
An S3 object of class \code{stansim_simulation} recording relevant
  simulation data.
}
\description{
\code{collect_simulations()} groups together an arbitrary number
  of objects with class \code{stansim_simulation} or
  \code{stansim_collection} into a single \code{stansim_collection} object.
  Allows for multiple simulations to be stored, saved, analysed and managed
  in a single object.
}
\examples{
\dontrun{
# group together stansim_simulation objects
collection_basic <- collect_simulations("Linear Regression Study", simulation1,
                            simulation2)

# group together stansim_simulations and stansim_collections
collection_extended <- collect_simulations("Extended Lin Reg Study", collection_basic,
                               simulation3)

# group together multiple stansim_collections
merged_collections <- collect_simulations("merged collections", collection_extended,
                              collection_additional)
}

}
