% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictive_interval.R
\name{predictive_interval.stapreg}
\alias{predictive_interval.stapreg}
\alias{predictive_interval}
\alias{predictive_interval.ppd}
\title{Predictive intervals}
\usage{
\method{predictive_interval}{stapreg}(object, prob = 0.9,
  newsubjdata = NULL, newdistdata = NULL, newtimedata = NULL,
  draws = NULL, subject_ID = NULL, group_ID = NULL, re.form = NULL,
  fun = NULL, seed = NULL, offset = NULL, ...)

\method{predictive_interval}{ppd}(object, prob = 0.9, ...)
}
\arguments{
\item{object}{Either a fitted model object returned by one of the 
\pkg{rstap} modeling functions (a \link[=stapreg-objects]{stapreg 
object}) or, for the \code{"ppd"} method, a matrix of draws from the 
posterior predictive distribution returned by 
\code{\link{posterior_predict}}.}

\item{prob}{A number \eqn{p \in (0,1)}{p (0 < p < 1)} indicating the desired
probability mass to include in the intervals. The default is to report
\eqn{90}\% intervals (\code{prob=0.9}) rather than the traditionally used
\eqn{95}\% .}

\item{newsubjdata}{Optionally, a data frame of the subject-specific data
in which to look for variables with which to predict.
If omitted, the original datasets are used. If \code{newsubjdata}
is provided and any variables were transformed (e.g. rescaled) in the data
used to fit the model, then these variables must also be transformed in
\code{newsubjdata}. This only applies if variables were transformed before
passing the data to one of the modeling functions and \emph{not} if
transformations were specified inside the model formula. Also see the Note
section below for a note about using the \code{newsubjdata} argument with with
binomial models.}

\item{newdistdata}{If newsubjdata is provided a data frame of the subject-distance
must also be given for models with a spatial component}

\item{newtimedata}{If newsubjdata is provided, a data frame of the subject-time data}

\item{draws, fun, offset, re.form, seed}{Passed to 
\code{\link[=posterior_predict]{posterior_predict}}.}

\item{subject_ID}{same as \code{\link{stap_glm}}}

\item{group_ID}{same as \code{\link{stap_glmer}}}

\item{...}{Currently ignored.}
}
\value{
A matrix with two columns and as many rows as are in \code{newsubjdata}. 
  If \code{newsubjdata} is not provided then the matrix will have as many rows as
  the data used to fit the model. For a given value of \code{prob}, \eqn{p},
  the columns correspond to the lower and upper \eqn{100p}\% central interval
  limits and have the names \eqn{100\alpha/2}\% and \eqn{100(1 -
  \alpha/2)}\%, where \eqn{\alpha = 1-p}. For example, if \code{prob=0.9} is
  specified (a \eqn{90}\% interval), then the column names will be
  \code{"5\%"} and \code{"95\%"}, respectively.
}
\description{
The \code{predictive_interval} function computes Bayesian predictive intervals. 
The method for stapreg objects calls \code{\link{posterior_predict}}
internally, whereas the method for objects of class \code{"ppd"} accepts the
matrix returned by \code{posterior_predict} as input and can be used to avoid
multiple calls to \code{posterior_predict}.
}
\examples{
if (!exists("example_model")) example(example_model)

predictive_interval(example_model)
newdata <- data.frame(subj_ID = c(1,1), measure_ID = c(1,2),
                     centered_income = c(-1,-.7), sex = c(0,0),
                     centered_age = c(-1,-.7)) 
# newdata
predictive_interval(example_model, newsubjdata = newdata,
                    newdistdata = distdata,
                    newtimedata = timedata,
                    subject_ID = "subj_ID",
                    group_ID = "measure_ID")

}
\seealso{
\code{\link{predictive_error}}, \code{\link{posterior_predict}}, 
  \code{\link{posterior_interval}}
}
