% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print-and-summary.R
\name{print.stapreg}
\alias{print.stapreg}
\title{Print method for stapreg objects}
\usage{
\method{print}{stapreg}(x, digits = 1, ...)
}
\arguments{
\item{x}{A fitted model object returned by one of the 
\pkg{rstap} modeling functions. See \code{\link{stapreg-objects}}.}

\item{digits}{Number of digits to use for formatting numbers.}

\item{...}{Ignored.}
}
\value{
Returns \code{x}, invisibly.
}
\description{
The \code{print} method for stapreg objects displays a compact summary of the
fitted model. See the \strong{Details} section below for descriptions of the
different components of the printed output. For additional summary statistics
and diagnostics use the \code{\link[=summary.stapreg]{summary}} method.
}
\details{
\subsection{Point estimates}{
Point estimates are medians computed from simulations.
For models fit using MCMC (\code{"sampling"}) the posterior
sample is used.  The point estimates reported are the same as the values
returned by \code{\link[=coef.stapreg]{coef}}.
}
\subsection{Uncertainty estimates (MAD_SD)}{
The standard deviations reported (labeled \code{MAD_SD} in the print output)
are computed from the same set of draws described above and are proportional
to the median absolute deviation (\code{\link[stats]{mad}}) from the median.
Compared to the raw posterior standard deviation, the MAD_SD will be
more robust for long-tailed distributions. These are the same as the values
returned by \code{\link[=se.stapreg]{se}}.
}
\subsection{Additional output}{
\itemize{
\item The median and MAD_SD are also reported for \code{mean_PPD}, the sample
average posterior predictive distribution of the outcome. This is useful as a
quick diagnostic. A useful heuristic is to check if \code{mean_PPD} is
plausible when compared to \code{mean(y)}. If it is plausible then this does
\emph{not} mean that the model is good in general (only that it can reproduce
the sample mean), however if \code{mean_PPD} is implausible then it is a sign
that something is wrong (severe model misspecification, problems with the
data, computational issues, etc.).

\item For GLMs with group-specific terms (see \code{\link{stap_glmer}}) the printed 
output also shows point estimates of the standard deviations of the group 
effects (and correlations if there are both intercept and slopes that vary by
group).

}
}
}
\seealso{
\code{\link{summary.stapreg}}, \code{\link{stapreg-methods}}
}
