% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stapreg-methods.R
\name{stapreg-methods}
\alias{stapreg-methods}
\alias{VarCorr}
\alias{fixef}
\alias{sigma}
\alias{coef.stapreg}
\alias{confint.stapreg}
\alias{fitted.stapreg}
\alias{nobs.stapreg}
\alias{nstap.stapreg}
\alias{ntap.stapreg}
\alias{nsap.stapreg}
\alias{nfix.stapreg}
\alias{nfix}
\alias{residuals.stapreg}
\alias{se.stapreg}
\alias{vcov.stapreg}
\alias{fixef.stapreg}
\alias{ngrps.stapreg}
\alias{ranef.stapreg}
\alias{sigma.stapreg}
\alias{VarCorr.stapreg}
\title{Methods for stapreg objects}
\usage{
\method{coef}{stapreg}(object, ...)

\method{confint}{stapreg}(object, ...)

\method{fitted}{stapreg}(object, ...)

\method{nobs}{stapreg}(object, ...)

\method{nstap}{stapreg}(object)

\method{ntap}{stapreg}(object)

\method{nsap}{stapreg}(object)

\method{nfix}{stapreg}(object, ...)

\method{residuals}{stapreg}(object, ...)

\method{se}{stapreg}(object, ...)

\method{vcov}{stapreg}(object, correlation = FALSE, ...)

\method{fixef}{stapreg}(object, ...)

\method{ngrps}{stapreg}(object, ...)

\method{ranef}{stapreg}(object, ...)

\method{sigma}{stapreg}(object, ...)

\method{VarCorr}{stapreg}(x, sigma = 1, ...)
}
\arguments{
\item{object, x}{A fitted model object returned by one of the 
\pkg{rstap} modeling functions. See \code{\link{stapreg-objects}}.}

\item{...}{Ignored}

\item{correlation}{For \code{vcov}, if \code{FALSE} (the default) the
covariance matrix is returned. If \code{TRUE}, the correlation matrix is
returned instead.}

\item{sigma}{Ignored (included for compatibility with
\code{\link[nlme]{VarCorr}}).}
}
\description{
The methods documented on this page are actually some of the least important 
methods defined for \link[=stapreg-objects]{stapreg} objects. The most 
important methods are documented separately, each with its own page. Links to
those pages are provided in the \strong{See Also} section, below.
}
\details{
The methods documented on this page are similar to the methods 
  defined for objects of class 'lm', 'glm', 'glmer', etc. However there are a
  few key differences:
  
\describe{
\item{\code{residuals}}{
Residuals are \emph{always} of type \code{"response"} (not \code{"deviance"}
residuals or any other type). }
\item{\code{coef}}{
Medians are used for point estimates. See the \emph{Point estimates} section
in \code{\link{print.stapreg}} for more details.
}
\item{\code{se}}{
The \code{se} function returns standard errors based on 
\code{\link{mad}}. See the \emph{Uncertainty estimates} section in
\code{\link{print.stapreg}} for more details.
}
\item{\code{confint}}{
\code{confint} will throw an error because the
\code{\link{posterior_interval}} function should be used to compute Bayesian 
uncertainty intervals.
}
}
}
\seealso{
\itemize{
 \item The \code{\link[=print.stapreg]{print}},
   \code{\link[=summary.stapreg]{summary}}, and \code{\link{prior_summary}} 
   methods for stapreg objects for information on the fitted model.
 \item The \code{\link[=plot.stapreg]{plot}} method to plot estimates and
   diagnostics.
 \item The \code{\link{posterior_predict}} and \code{\link{predictive_error}}
   methods for predictions and predictive errors - can be used for posterior predictive checks.
 \item The \code{\link{posterior_interval}} and \code{\link{predictive_interval}}
   methods for uncertainty intervals for model parameters and predictions.
 \item \code{\link{log_lik}} method for  computing the log-likelihood 
  of (possibly new) data.
 \item The \code{\link[=as.matrix.stapreg]{as.matrix}}, \code{as.data.frame}, 
   and \code{as.array} methods to access posterior draws.
}
}
