% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation.R
\name{start_annotation_batch}
\alias{start_annotation_batch}
\title{Start batch annotation}
\usage{
start_annotation_batch(dataset_id, title, layers)
}
\arguments{
\item{dataset_id}{The id of the dataset. List your datasets with the my_datasets() function.}

\item{title}{The title of the annotation job.}

\item{layers}{A list of parameters or vector of codes, of the layers, see the examples below.}
}
\value{
No return value, check my_jobs() to confirm successful job submission.
}
\description{
Submit a dataset previously uploaded on mol.org for annotation.
To upload a dataset please visit https://mol.org/upload/
Requires login, please run mol_login(<email_address>)
}
\examples{
\dontrun{
start_annotation_batch('<dataset_id>', 'My annotation task', layers = list(
   list(product = "chelsa", variable = "precip", spatial = 1000, temporal = 30)
))
# alternatively supplying the code is fine.
start_annotation_batch('<datset_id>',
  'My 2nd annotation task', layers = c("modis-ndvi-1000-1", "modis-lst_day-1000-1"))
}
}
