% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoring_matrices.R
\name{make_scoring_matrix_trivial}
\alias{make_scoring_matrix_trivial}
\title{Make scoring matrix}
\usage{
make_scoring_matrix_trivial(
  responses,
  nTraits = 1L,
  traitsNames = paste0("F", 1L:nTraits)
)
}
\arguments{
\item{responses}{vector of available responses (\emph{categories}) - can be
a character vector or positive integer describing number of responses}

\item{nTraits}{optionally number of traits affecting the item response;
disregarded if \code{traitsNames} are provided}

\item{traitsNames}{optionally character vector containing names of the traits}
}
\value{
matrix of integers
}
\description{
Makes trivial response matrix, corresponding to the most simple,
the same for each trait GPCM scoring scheme. This function may be useful if
one wants to use \code{\link{generate_slopes}} and
\code{\link{generate_intercepts}} functions to generate items' parameters
with no reference to response styles.
}
\examples{
make_scoring_matrix_trivial(5, 2)
make_scoring_matrix_trivial(5, traitsNames = c("A", "B"))
}
