/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data.discretization;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.vikamine.kernel.data.discretization.AbstractSupervisedDiscretizationMethod;
import org.vikamine.kernel.data.discretization.DiscretizationUtils;
import org.vikamine.kernel.subgroup.target.BooleanTarget;
import org.vikamine.kernel.subgroup.target.SGTarget;

public abstract class SupervisedBinaryDiscretizer
extends AbstractSupervisedDiscretizationMethod {
    public SupervisedBinaryDiscretizer(SGTarget target) {
        super(target);
    }

    public SupervisedBinaryDiscretizer() {
    }

    private BlockGenerator generateBlocks(BooleanTarget target) {
        BlockGenerator generator = new BlockGenerator(target);
        generator.initialize();
        return generator;
    }

    @Override
    public List<Double> getCutpoints() {
        if (!this.check()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Double> result = new ArrayList<Double>();
        this.sortedSample = DiscretizationUtils.getSortedDataRecords(this.population, this.attribute, false, false);
        BlockGenerator generator = this.generateBlocks((BooleanTarget)this.target);
        this.makeBinaryPartition(generator.firstBlock, generator.lastBlock).toList(result);
        return result;
    }

    abstract BinaryPartition makeBinaryPartition(InstanceBlock var1, InstanceBlock var2);

    static abstract class BinaryPartition {
        BoundaryPoint cutPoint;
        BinaryPartition lowerPartition;
        BinaryPartition upperPartition;
        boolean isAccepted;

        BinaryPartition() {
        }

        static int size(InstanceBlock lastBlock) {
            return lastBlock.cumsumNegatives + lastBlock.cumsumPositives;
        }

        static int size(BoundaryPoint lowerBoundary, BoundaryPoint upperBoundary, InstanceBlock lastBlock) {
            if (upperBoundary == null) {
                if (lowerBoundary == null) {
                    return lastBlock.cumSize();
                }
                return lowerBoundary.sumNegativesUpperCut(upperBoundary, lastBlock) + lowerBoundary.sumPositivesUpperCut(upperBoundary, lastBlock);
            }
            return upperBoundary.sumNegativesLowerCut(lowerBoundary) + upperBoundary.sumPositivesLowerCut(lowerBoundary);
        }

        private List<Double> toList(List<Double> list) {
            if (this.cutPoint == null || !this.isAccepted) {
                return list;
            }
            if (this.lowerPartition != null) {
                this.lowerPartition.toList(list);
            }
            list.add(this.cutPoint.toDouble());
            if (this.upperPartition != null) {
                this.upperPartition.toList(list);
            }
            return list;
        }
    }

    private final class BlockGenerator
    extends AbstractSupervisedDiscretizationMethod.Initializer {
        private final InstanceBlock firstBlock;
        private InstanceBlock lastBlock;
        private InstanceBlock currentBlock;

        private BlockGenerator(BooleanTarget target) {
            super(target);
            this.currentBlock = this.firstBlock = new InstanceBlock(this.getValue());
        }

        @Override
        void finish() {
            this.lastBlock = this.currentBlock;
            this.lastBlock.maxValue = this.getValue();
            this.lastBlock.cumsumNegatives = this.sumNegatives;
            this.lastBlock.cumsumPositives = this.sumPositives;
        }

        @Override
        void createNewBlock() {
            this.currentBlock.upperBoundary = new BoundaryPoint(this.currentBlock);
            this.currentBlock.cumsumNegatives = this.sumNegatives;
            this.currentBlock.cumsumPositives = this.sumPositives;
            this.currentBlock.maxValue = this.getPrevValue();
            InstanceBlock upperBlock = new InstanceBlock(this.getValue());
            this.currentBlock.upperBoundary.upperBlock = upperBlock;
            this.currentBlock = upperBlock;
        }
    }

    static final class BoundaryPoint {
        private final WeakReference<InstanceBlock> lowerBlock;
        private InstanceBlock upperBlock;

        private BoundaryPoint(InstanceBlock lowerBlock) {
            this.lowerBlock = new WeakReference<InstanceBlock>(lowerBlock);
        }

        int sumNegativesLowerCut(BoundaryPoint lowerBoundary) {
            return ((InstanceBlock)this.lowerBlock.get()).getSumNegativesLowerCut(lowerBoundary);
        }

        int sumPositivesLowerCut(BoundaryPoint lowerBoundary) {
            return ((InstanceBlock)this.lowerBlock.get()).getSumPositivesLowerCut(lowerBoundary);
        }

        int sumNegativesUpperCut(BoundaryPoint upperBoundary, InstanceBlock lastBlock) {
            if (upperBoundary == null) {
                return lastBlock.cumsumNegatives - ((InstanceBlock)this.lowerBlock.get()).cumsumNegatives;
            }
            return ((InstanceBlock)upperBoundary.lowerBlock.get()).cumsumNegatives - ((InstanceBlock)this.lowerBlock.get()).cumsumNegatives;
        }

        int sumPositivesUpperCut(BoundaryPoint upperBoundary, InstanceBlock lastBlock) {
            if (upperBoundary == null) {
                return lastBlock.cumsumPositives - ((InstanceBlock)this.lowerBlock.get()).cumsumPositives;
            }
            return ((InstanceBlock)upperBoundary.lowerBlock.get()).cumsumPositives - ((InstanceBlock)this.lowerBlock.get()).cumsumPositives;
        }

        BoundaryPoint nextCutPoint() {
            return this.upperBlock.upperBoundary;
        }

        private double toDouble() {
            return (((InstanceBlock)this.lowerBlock.get()).maxValue + this.upperBlock.minValue) / 2.0;
        }
    }

    static final class InstanceBlock {
        private final double minValue;
        private double maxValue;
        BoundaryPoint upperBoundary;
        int cumsumNegatives;
        int cumsumPositives;

        private InstanceBlock(double minValue) {
            this.minValue = minValue;
        }

        int getSumNegativesLowerCut(BoundaryPoint lowerBoundary) {
            if (lowerBoundary == null) {
                return this.cumsumNegatives;
            }
            return this.cumsumNegatives - ((InstanceBlock)((BoundaryPoint)lowerBoundary).lowerBlock.get()).cumsumNegatives;
        }

        int getSumPositivesLowerCut(BoundaryPoint lowerBoundary) {
            if (lowerBoundary == null) {
                return this.cumsumPositives;
            }
            return this.cumsumPositives - ((InstanceBlock)((BoundaryPoint)lowerBoundary).lowerBlock.get()).cumsumPositives;
        }

        private int cumSize() {
            return this.cumsumNegatives + this.cumsumPositives;
        }
    }
}

