/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.quality;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.DataView;
import org.vikamine.kernel.data.Value;
import org.vikamine.kernel.subgroup.ISubgroup;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.quality.IQualityFunction;
import org.vikamine.kernel.subgroup.target.NumericTarget;

public abstract class AbstractRankedBasedQF
implements IQualityFunction {
    @Override
    public boolean isApplicable(ISubgroup<DataRecord> subgroup) {
        if (!(subgroup instanceof SG)) {
            return false;
        }
        SG sg = (SG)subgroup;
        return sg.getTarget() != null && sg.getTarget().isNumeric();
    }

    @Override
    public double evaluate(ISubgroup<DataRecord> subgroup) {
        SG sg = (SG)subgroup;
        if (sg.getStatistics() == null) {
            sg.createStatistics();
        }
        DataView dataView = sg.getPopulation();
        final NumericTarget target = (NumericTarget)sg.getTarget();
        ArrayList<DataRecord> drs = new ArrayList<DataRecord>();
        for (DataRecord dr : dataView) {
            if (Value.isMissingValue(target.getValue(dr))) continue;
            drs.add(dr);
        }
        Collections.sort(drs, new Comparator<DataRecord>(){

            @Override
            public int compare(DataRecord o1, DataRecord o2) {
                return -Double.compare(target.getValue(o1), target.getValue(o2));
            }
        });
        double[] ranks = this.createRanks(drs, target);
        ArrayList<Double> ranksSG = new ArrayList<Double>();
        int i = 0;
        for (DataRecord dr : drs) {
            if (sg.getSGDescription().isMatching(dr)) {
                ranksSG.add(ranks[i]);
            }
            ++i;
        }
        return this.evaluateRanks((int)sg.getStatistics().getDefinedPopulationCount(), ranksSG);
    }

    public abstract double evaluateRanks(int var1, List<Double> var2);

    protected double[] createRanks(List<DataRecord> drs, NumericTarget target) {
        double[] ranks = new double[drs.size()];
        int startOfCurrentGroup = 0;
        double lastValue = Double.MAX_VALUE;
        int i = 0;
        while (i < drs.size()) {
            double value = target.getValue(drs.get(i));
            if (lastValue != value) {
                double rank = (double)drs.size() - ((double)i - 1.0 + (double)startOfCurrentGroup) / 2.0;
                int j = startOfCurrentGroup;
                while (j <= i - 1) {
                    ranks[j] = rank;
                    ++j;
                }
                startOfCurrentGroup = i;
            }
            lastValue = value;
            ++i;
        }
        double rank = (double)drs.size() - ((double)drs.size() - 1.0 + (double)startOfCurrentGroup) / 2.0;
        int j = startOfCurrentGroup;
        while (j <= drs.size() - 1) {
            ranks[j] = rank;
            ++j;
        }
        return ranks;
    }

    @Override
    public abstract AbstractRankedBasedQF clone();
}

