/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.util;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.data.RDFStatement;
import org.vikamine.kernel.subgroup.selectors.DefaultSGSelector;

public class RDFExporter {
    public static void writeTriples(String path, List<RDFStatement> menge) {
        String longPre = "org.vikamine.rdf";
        String shortPre = "vik";
        Namespace space = Namespace.getNamespace(shortPre, longPre);
        Document doc = new Document();
        ArrayList subjs = new ArrayList();
        Hashtable table = new Hashtable();
        int i = 0;
        while (i < menge.size()) {
            if (!subjs.contains(menge.get(i).getSubject())) {
                subjs.add(menge.get(i).getSubject());
                ArrayList<RDFStatement> belongstoSubject = new ArrayList<RDFStatement>();
                belongstoSubject.add(menge.get(i));
                table.put(menge.get(i).getSubject(), belongstoSubject);
            } else {
                ArrayList state = (ArrayList)table.get(menge.get(i).getSubject());
                state.add(menge.get(i));
            }
            ++i;
        }
        Element elRoot = new Element("RDFStatements", shortPre, longPre);
        for (Object obj : subjs) {
            Element elSubject = null;
            if (obj instanceof Attribute) {
                elSubject = new Element("Attribute", shortPre, longPre);
                elSubject.setAttribute("id", ((Attribute)obj).getId(), space);
            } else if (obj instanceof Ontology) {
                elSubject = new Element("Ontology", shortPre, longPre);
            } else if (obj instanceof RDFStatement) {
                elSubject = new Element("RDFStatement", shortPre, longPre);
                elSubject.setAttribute("id", ((RDFStatement)obj).toString(), space);
            } else if (obj instanceof DefaultSGSelector) {
                elSubject = new Element("DefaultSGSelector", shortPre, longPre);
                elSubject.setAttribute("id", ((DefaultSGSelector)obj).getDescription(), space);
            } else if (obj instanceof String) {
                elSubject = new Element("Parsable", shortPre, longPre);
                elSubject.setAttribute("id", obj.toString(), space);
            } else if (obj instanceof String) {
                elSubject = new Element("Parsable", shortPre, longPre);
                elSubject.setAttribute("id", obj.toString(), space);
            } else {
                System.out.println("RDF Exporter: I can't handle this type: " + obj);
            }
            List statements = (List)table.get(obj);
            for (RDFStatement stat : statements) {
                Element elState = new Element("Predicate", shortPre, longPre);
                elState.setAttribute("about", RDFExporter.makePredicate(stat.getPredicate()), space);
                elState.addContent(new Text(RDFExporter.getUnique(stat.getObject()).toString()));
                if (elSubject == null) continue;
                elSubject.addContent(elState);
            }
            if (elSubject == null) continue;
            elRoot.addContent(elSubject);
        }
        Format format = Format.getPrettyFormat();
        format.setEncoding("iso-8859-1");
        doc.setContent(elRoot);
        try {
            XMLOutputter xmlOut = new XMLOutputter(format);
            xmlOut.output(doc, (OutputStream)new FileOutputStream(path));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String makePredicate(String predicate) {
        return predicate;
    }

    public static Object getUnique(Object toUnique) {
        if (toUnique instanceof Attribute) {
            return ((Attribute)toUnique).getId();
        }
        if (toUnique instanceof Ontology) {
            return "Ontology";
        }
        if (toUnique instanceof String) {
            return toUnique;
        }
        return toUnique;
    }
}

