% Generated by roxygen2 (4.0.1): do not edit by hand
\name{cg_hearings}
\alias{cg_hearings}
\title{Search for data on hearings}
\usage{
cg_hearings(committee_id = NULL, occurs_at = NULL, congress = NULL,
  chamber = NULL, dc = NULL, bill_ids = NULL, hearing_type = NULL,
  query = NULL, fields = NULL, page = 1, per_page = 20, order = NULL,
  key = getOption("SunlightLabsKey",
  stop("need an API key for Sunlight Labs")), return = "table", ...)
}
\arguments{
\item{committee_id}{(numeric) The ID of the committee holding the hearing.}

\item{occurs_at}{(numeric) The time the hearing will occur.}

\item{congress}{(numeric) The number of the Congress the committee hearing is taking place during.}

\item{chamber}{(character) The chamber ('house', 'senate', or 'joint') of the committee holding the hearing.}

\item{dc}{(logical) Whether the committee hearing is held in DC (TRUE) or in the field (FALSE).}

\item{bill_ids}{(numeric) The IDs of any bills mentioned by or associated with the hearing.}

\item{hearing_type}{(character) (House only) The type of hearing this is. Can be: 'Hearing',
'Markup', 'Business Meeting', 'Field Hearing'.}

\item{fields}{You can request specific fields by supplying a vector of fields names. Many fields
are not returned unless requested. If you don't supply a fields parameter, you will get the
most commonly used subset of fields only. To save on bandwidth, parsing time, and confusion,
it's recommended to always specify which fields you will be using.}

\item{key}{your SunlightLabs API key; loads from .Rprofile}

\item{return}{(character) One of table (default), list, or response (httr response object).
When table is requested, the default, a table is not always returned, but is returned almost
always. You can then make a table yourself if you like.}

\item{...}{Optional additional curl options (debugging tools mostly). See examples.}

\item{page}{Page to return. Default: 1. You can use this in combination with the
per_page parameter to get more than the default or max number of results per page.}

\item{per_page}{Number of records to return. Default: 20. Max: 50.}

\item{order}{Sort results by one or more fields with the order parameter. order is
optional, but if no order is provided, the order of results is not guaranteed to be predictable.
Append \code{__asc} or \code{__desc} to the field names to control sort direction. The default
direction is \code{desc}, because it is expected most queries will sort by a date. Any field
which can be used for filtering may be used for sorting. On full-text search endpoints (URLs
ending in \code{/search}), you may sort by score to order by relevancy.}

\item{query}{(character) Return results the API thinks best match your query. Queries are
interpreted as phrases.}
}
\description{
Search for data on hearings
}
\examples{
\dontrun{
cg_hearings(chamber='house', dc=TRUE)
cg_hearings(query='children')
}
}

