% Generated by roxygen2 (4.0.1): do not edit by hand
\name{ie_entities}
\alias{ie_entities}
\title{Search for entities.}
\usage{
ie_entities(search = NULL, type = NULL, namespace = NULL, id = NULL,
  bioguide_id = NULL, entity_id = NULL, page = NULL, per_page = NULL,
  return = "table", key = getOption("SunlightLabsKey",
  stop("need an API key for Sunlight Labs")), ...)
}
\arguments{
\item{search}{(character) The query string. There are no logic operators or grouping.}

\item{type}{(character) Filter results to a particular type of entity. One of politician,
organization, individual or industry.}

\item{namespace}{(character) The dataset and data type of the ID. Currently allowed values are:
urn:crp:individual (A CRP ID for an individual contributor or lobbyist. Begins with U or C.)
urn:crp:organization (A CRP ID for an organization. Begins with D.)
urn:crp:recipient (A CRP ID for a politician. Begins with N.)
urn:nimsp:organization (A NIMSP ID for an organization. Integer-valued.)
urn:nimsp:recipient (A NIMSP ID for a politician. Integer-valued.)}

\item{id}{(character) The ID of the entity in the given namespace.}

\item{bioguide_id}{(character) The ID of a member of congress in the Congressional Bioguide
(\url{http://bioguide.congress.gov/biosearch/biosearch.asp}). Mutually exclusive to the
id/namespace parameters. Required, if namespace and id are omitted.}

\item{entity_id}{(character) The transparencydata ID to look up.}

\item{page}{The page of results to return; defaults to 1.}

\item{per_page}{The number of results to return per page, defaults to 1,000.
The maximum number of records per page is 100,000.}

\item{key}{your SunlightLabs API key; loads from .Rprofile}

\item{...}{Optional additional curl options (debugging tools mostly)}

\item{return}{(character) One of table (default), list, or response (httr response object).
When table is requested, the default, a table is not always returned, but is returned almost
always. You can then make a table yourself if you like.}
}
\value{
A list. Depends on parameters used. Ranges from a single ID returned to basic
   information about the the contributions to and from each entity.
}
\description{
Search for politicians, individuals, or organizations with the given name.
}
\examples{
\dontrun{
# Search with text string
ie_entities(search='Nancy Pelosi')
head(ie_entities(search='Jones', type='politician'))
head(ie_entities(search='Jones', type='organization'))

# Search for an ID by namespace and id
ie_entities(namespace = 'urn:crp:recipient', id = 'N00007360')

# Search for an ID by bioguide id
ie_entities(bioguide_id='L000551')

# Search for data by entity id
ie_entities(entity_id='97737bb56b6a4211bcc57a837368b1a4')
}
}

