% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scto_read.R
\name{scto_read}
\alias{scto_read}
\title{Access SurveyCTO data using the API}
\usage{
scto_read(
  auth,
  id,
  type = c("dataset", "form"),
  start_date = "1900-01-01",
  review_status = "approved",
  private_key = NULL,
  drop_empty_cols = TRUE,
  convert_datetime = c("CompletionDate", "SubmissionDate", "starttime", "endtime"),
  datetime_format = "\%b \%e, \%Y \%I:\%M:\%S \%p"
)
}
\arguments{
\item{auth}{\code{\link[=scto_auth]{scto_auth()}} object.}

\item{id}{String indicating ID of the dataset or form.}

\item{type}{String indicating whether \code{id} corresponds to a dataset or form.}

\item{start_date}{Date-time or something coercible to a date-time
indicating the earliest date-time for which to fetch data. Only used for
forms.}

\item{review_status}{String or character vector indicating which submissions
to fetch. Possible values are "approved", "pending", "rejected", or any
combination of the three. Only used for forms.}

\item{private_key}{String indicating path to private key file. Only needs to
be non-\code{NULL} to read encrypted form data.}

\item{drop_empty_cols}{Logical indicating whether to drop columns that
contain only \code{NA} or only an empty string.}

\item{convert_datetime}{Character vector of column names in the data for
which to convert strings to datetimes (POSIXct). Use \code{NULL} to not convert
any columns to datetimes.}

\item{datetime_format}{String indicating format of datetimes from SurveyCTO.
See \code{\link[=strptime]{strptime()}}.}
}
\value{
A \code{data.table}.
}
\description{
This function reads data from SurveyCTO using the API.
}
\examples{
\dontrun{
auth = scto_auth('scto_auth.txt')
scto_data = scto_read(auth, 'my_form', 'form')
}

}
\seealso{
\code{\link[=scto_auth]{scto_auth()}}, \code{\link[=scto_get_attachments]{scto_get_attachments()}}, \code{\link[=scto_write]{scto_write()}}
}
