% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveDatasheet.R
\name{saveDatasheet}
\alias{saveDatasheet}
\alias{saveDatasheet,character-method}
\alias{saveDatasheet,SsimObject-method}
\title{Save datasheet(s)}
\usage{
saveDatasheet(
  ssimObject,
  data,
  name = NULL,
  fileData = NULL,
  append = NULL,
  forceElements = FALSE,
  force = FALSE,
  breakpoint = FALSE,
  import = TRUE,
  path = NULL
)

\S4method{saveDatasheet}{character}(
  ssimObject,
  data,
  name = NULL,
  fileData = NULL,
  append = NULL,
  forceElements = FALSE,
  force = FALSE,
  breakpoint = FALSE,
  import = TRUE,
  path = NULL
)

\S4method{saveDatasheet}{SsimObject}(
  ssimObject,
  data,
  name = NULL,
  fileData = NULL,
  append = NULL,
  forceElements = FALSE,
  force = FALSE,
  breakpoint = FALSE,
  import = TRUE,
  path = NULL
)
}
\arguments{
\item{ssimObject}{SsimLibrary/Project/Scenario.}

\item{data}{A dataframe, named vector, or list of these. One or more datasheets to load.}

\item{name}{Character or vector of these. The name(s) of the datasheet(s) to be saved. If a vector of names is provided, then a list must be provided for the data argument. Names provided here will override those provided with data argument's list.}

\item{fileData}{Named list or raster stack. Names are file names (without paths), corresponding to entries in data. The elements are objects containing the data associated with each name. Currently only supports Raster objects as elements.}

\item{append}{Logical. If TRUE, the incoming data will be appended to the datasheet if possible.  Default TRUE for project/library-scope datasheets, and FALSE for scenario-scope datasheets. See 'details' for more information about this argument.}

\item{forceElements}{Logical. If FALSE (default) a single return message will be returned as a character string. Otherwise it will be returned in a list.}

\item{force}{Logical. If datasheet scope is project/library, and append=FALSE, datasheet will be deleted before loading the new data. This can also delete other definitions and results, so user will be prompted for approval unless force=TRUE.}

\item{breakpoint}{Set to TRUE when modifying datasheets in a breakpoint function.}

\item{import}{Logical. Set to TRUE to import the data after saving.}

\item{path}{Character.  An optional output path.}
}
\value{
This function invisibly returns a vector or list of logical values for each input: `TRUE` upon success (i.e.successful save)
and `FALSE` upon failure.
}
\description{
Saves datasheets to a SsimLibrary/Project/Scenario.
}
\details{
ssimObject/project/scenario should identify a single ssimObject.

If fileData !=NULL, each element of names(fileData) should correspond uniquely to at most one entry in data. If a name is not found in data the element will be ignored with a warning.
If names(fileData) are full filepaths, rsyncrosim will write each object to the corresponding path for subsequent loading by SyncroSim. Note this is generally more time-consuming because the files must be written twice.
If names(fileData) are not filepaths (faster, recommended), rsyncrosim will write each element directly to the appropriate SyncroSim input/output folders.
rsyncrosim will write each element of fileData directly to the appropriate SyncroSim input/output folders.
If fileData != NULL, data should be a dataframe, vector, or list of length 1, not a list of length >1.

About the 'append' argument:

\itemize{
  \item A datasheet is a VALIDATION SOURCE if its data can be used to validate column values in a different datasheet.
  \item The append argument will be ignored if the datasheet is a validation source and has a project scope.  In this case the data will be MERGED.
}
}
