% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updatePackage.R
\name{updatePackage}
\alias{updatePackage}
\alias{updatePackage,ANY,character-method}
\alias{updatePackage,ANY,missingOrNULL-method}
\alias{updatePackage,ANY,Session-method}
\title{Update Package}
\usage{
updatePackage(name = NULL, session = NULL, listonly = FALSE)

\S4method{updatePackage}{ANY,character}(name = NULL, session = NULL, listonly = FALSE)

\S4method{updatePackage}{ANY,missingOrNULL}(name = NULL, session = NULL, listonly = FALSE)

\S4method{updatePackage}{ANY,Session}(name = NULL, session = NULL, listonly = FALSE)
}
\arguments{
\item{name}{character string.  The name of the package to update.
If \code{NULL} (default), all packages will be updated}

\item{session}{\code{\link{Session}} object. If \code{NULL} (default),
\code{session()} is used}

\item{listonly}{logical. If \code{TRUE}, available updates are listed only.
Default is \code{FALSE}}
}
\value{
Invisibly returns \code{TRUE} upon success (i.e.successful update)
and \code{FALSE} upon failure.
}
\description{
Updates a SyncroSim package.
}
\examples{
\dontrun{
# Set SyncroSim Session
mySession <- session()

# List all available updates for a package
updatePackage(name = "stsim", session = mySession, listonly = TRUE)

# Update ST-Sim package
updatePackage(name = "stsim", session = mySession, listonly = FALSE)

# Update all packages
updatePackage(session = mySession)
}

}
