% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasheetSpatRaster.R
\name{datasheetSpatRaster}
\alias{datasheetSpatRaster}
\alias{datasheetSpatRaster,character-method}
\alias{datasheetSpatRaster,list-method}
\alias{datasheetSpatRaster,SsimObject-method}
\alias{datasheetSpatRaster,Scenario-method}
\title{Retrieve spatial data from a SyncroSim Datasheet}
\usage{
datasheetSpatRaster(
  ssimObject,
  datasheet,
  column = NULL,
  scenario = NULL,
  iteration = NULL,
  timestep = NULL,
  filterColumn = NULL,
  filterValue = NULL,
  subset = NULL,
  forceElements = FALSE,
  pathOnly = FALSE
)

\S4method{datasheetSpatRaster}{character}(
  ssimObject,
  datasheet,
  column = NULL,
  scenario = NULL,
  iteration = NULL,
  timestep = NULL,
  filterColumn = NULL,
  filterValue = NULL,
  subset = NULL,
  forceElements = FALSE,
  pathOnly = FALSE
)

\S4method{datasheetSpatRaster}{list}(
  ssimObject,
  datasheet,
  column = NULL,
  scenario = NULL,
  iteration = NULL,
  timestep = NULL,
  filterColumn = NULL,
  filterValue = NULL,
  subset = NULL,
  forceElements = FALSE,
  pathOnly = FALSE
)

\S4method{datasheetSpatRaster}{SsimObject}(
  ssimObject,
  datasheet,
  column = NULL,
  scenario = NULL,
  iteration = NULL,
  timestep = NULL,
  filterColumn = NULL,
  filterValue = NULL,
  subset = NULL,
  forceElements = FALSE,
  pathOnly = FALSE
)

\S4method{datasheetSpatRaster}{Scenario}(
  ssimObject,
  datasheet,
  column = NULL,
  scenario = NULL,
  iteration = NULL,
  timestep = NULL,
  filterColumn = NULL,
  filterValue = NULL,
  subset = NULL,
  forceElements = FALSE,
  pathOnly = FALSE
)
}
\arguments{
\item{ssimObject}{SsimLibrary/Project/Scenario object or list of Scenario objects. If
SsimLibrary/Project, then \code{scenario} argument is required}

\item{datasheet}{character string. The name of the Datasheet containing the
raster data}

\item{column}{character string. The name of the column in the datasheet containing
the file names for raster data. If \code{NULL} (default) then use the first
column that contains raster file names}

\item{scenario}{character string, integer, or vector of these. The Scenarios to
include. Required if SsimObject is an SsimLibrary/Project, ignored if
SsimObject is a list of Scenarios (optional)}

\item{iteration}{integer, character string, or vector of integer/character strings.
Iteration(s) to include. If \code{NULL} (default) then all iterations are
included. If no Iteration column is in the Datasheet, then ignored}

\item{timestep}{integer, character string, or vector of integer/character string.
Timestep(s) to include. If \code{NULL} (default) then all timesteps are
included.  If no Timestep column is in the Datasheet, then ignored}

\item{filterColumn}{character string. The column to filter a Datasheet by.
(e.g. "TransitionGroupID"). Note that to use the filterColumn argument,
you must also specify a filterValue. Default is \code{NULL}}

\item{filterValue}{character string or integer. The value of the filterColumn
to filter the Datasheet by. To use the filterValue argument, you must
also specify a filterColumn. Default is \code{NULL}}

\item{subset}{logical expression indicating Datasheet rows to return.
e.g. expression(grepl("Ts0001", Filename, fixed=T)). See subset() for
details (optional)}

\item{forceElements}{logical. If \code{TRUE} then returns a single raster as a RasterStack;
otherwise returns a single raster as a RasterLayer directly. Default is
\code{FALSE}}

\item{pathOnly}{logical. If \code{TRUE} then returns a list of filepaths to the raster
files on disk. Default is \code{FALSE}}
}
\value{
A SpatRaster object, or List. See terra package documentation for details.
}
\description{
This function retrieves spatial columns from one or more SyncroSim
\code{\link{Scenario}} Datasheets.
}
\details{
The names of the returned SpatRaster contain metadata.
For Datasheets without Filename this is:

\code{paste0(<datasheet name>,".Scn",<scenario id>,".",<tif name>)}.

For Datasheets containing Filename this is:

\code{paste0(<datasheet name>,".Scn",<scenario id>,".It",<iteration>,".Ts",<timestep>)}.
}
\examples{
\dontrun{
# Install the helloworldSpatial package from the server
installPackage("helloworldSpatial")

# Specify file path and name of new SsimLibrary
myLibraryName <- file.path(tempdir(), "testlib_datasheetSpatRaster")

# Set up a SyncroSim Session
mySession <- session()

# Use the example template library from helloworldSpatial
myLibrary <- ssimLibrary(name = myLibraryName,
                         session = mySession,
                         packages = "helloworldSpatial")

# Set up Project and Scenario
myProject <- project(myLibrary, project = "Definitions")
myScenario <- scenario(myProject, scenario = "My Scenario")

# Run Scenario to generate results
resultScenario <- run(myScenario)

# Extract specific Datasheet rasters by iteration and timestep
resultRaster <- datasheetSpatRaster(resultScenario,
                  datasheet = "helloworldSpatial_IntermediateDatasheet",
                  column = "OutputRasterFile",
                  iteration = 3,
                  timestep = 2
)

# Extract specific Datasheet SpatRasters using pattern matching
resultDatasheet <- datasheet(resultScenario, 
                             name = "helloworldSpatial_IntermediateDatasheet")
colnames(resultDatasheet)
outputRasterPaths <- resultDatasheet$OutputRasterFile
resultRaster <- datasheetSpatRaster(resultScenario, 
                  datasheet = "helloworldSpatial_IntermediateDatasheet",
                  column = "OutputRasterFile",
                  subset = expression(grepl("ts20", 
                                             outputRasterPaths,
                                             fixed = TRUE))
)

# Return the raster Datasheets as a SpatRaster list
resultRaster <- datasheetSpatRaster(resultScenario, 
                 datasheet = "helloworldSpatial_IntermediateDatasheet",
                 column = "OutputRasterFile",
                 forceElements = TRUE)
                 
# Filter for only rasters that fit specific criteria
# Load the ST-Sim spatial example library
installPackage("stsim")

# Set the file path and name of the new SsimLibrary
myLibraryName <- file.path(tempdir(),"testlib_stsim_datasheet")

# Set the SyncroSim Session
mySession <- session()

# Create a new SsimLibrary with the example template from ST-Sim
myLibrary <- ssimLibrary(name = myLibraryName,
                         session = mySession, 
                         packages = "stsim")
                         
myScenario <- scenario(myLibrary, scenario = 16)

# Run Scenario to generate results
resultScenario <- run(myScenario)


resultRaster <- datasheetSpatRaster(resultScenario,
                 datasheet = "stsim_OutputSpatialState",
                 timestep = 5,
                 iteration = 5,
                 filterColumn = "TransitionTypeID",
                 filterValue = "Fire")
}

}
