% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate.r
\name{get_nodes}
\alias{get_nodes}
\title{Transform the nodes to long format and match with token data}
\usage{
get_nodes(tokens, nodes, use = NULL, token_cols = c("token"))
}
\arguments{
\item{tokens}{A tokenIndex data.table, or any data.frame coercible with \link{as_tokenindex}.}

\item{nodes}{A data.table, as created with \link{apply_queries}. Can be a list of multiple data.tables.}

\item{use}{Optionally, specify which columns from nodes to add. Other than convenient, this is slighly different 
from subsetting the columns in 'nodes' beforehand if fill is TRUE. When the children are collected,
the ids from the not-used columns are still blocked (see 'block')}

\item{token_cols}{A character vector, specifying which columns from tokens to include in the output}
}
\value{
A data.table with the nodes in long format, and the specified token_cols attached
}
\description{
Transform the nodes to long format and match with token data
}
\examples{
## spacy tokens for: Mary loves John, and Mary was loved by John
tokens = tokens_spacy[tokens_spacy$doc_id == 'text3',]

## two simple example tqueries
passive = tquery(pos = "VERB*", label = "predicate",
                 children(relation = c("agent"), label = "subject"))
active =  tquery(pos = "VERB*", label = "predicate",
                 children(relation = c("nsubj", "nsubjpass"), label = "subject"))

nodes = apply_queries(tokens, pas=passive, act=active)
get_nodes(tokens, nodes)
}
