% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_compatibility.R
\name{rrowl}
\alias{rrowl}
\title{rrowl}
\usage{
rrowl(row.name, ..., format = NULL, indent = 0)
}
\arguments{
\item{row.name}{if \code{NULL} then the \code{FUN} argument is deparsed and
used as \code{row.name} of the \code{\link{rrow}}}

\item{\dots}{values in vector/list form}

\item{format}{if \code{FUN} does not return a formatted \code{\link{rcell}}
then the \code{format} is applied}

\item{indent}{deprecated.}
}
\value{
A row object of the context-appropriate type (label or data)
}
\description{
rrowl
}
\examples{
rrowl("a", c(1,2,3), format = "xx")
rrowl("a", c(1,2,3), c(4,5,6), format = "xx")


rrowl("N", table(iris$Species))
rrowl("N", table(iris$Species), format = "xx")

x <- tapply(iris$Sepal.Length, iris$Species, mean, simplify = FALSE)

rrow(row.name = "row 1", x)
rrow("ABC", 2, 3)

rrowl(row.name = "row 1", c(1, 2), c(3,4))
rrow(row.name = "row 2", c(1, 2), c(3,4))
}
