% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argument_conventions.R
\name{constr_args}
\alias{constr_args}
\title{Constructor argument conventions}
\usage{
constr_args(
  kids,
  cont,
  lev,
  iscontent,
  cinfo,
  labelrow,
  vals,
  cspan,
  label_pos,
  cindent_mod,
  cvar,
  label,
  cextra_args,
  child_names,
  title,
  subtitles,
  main_footer,
  prov_footer,
  footnotes,
  page_title,
  page_prefix,
  section_div,
  trailing_section_div,
  split_na_str,
  cna_str,
  inset,
  table_inset,
  header_section_div
)
}
\arguments{
\item{kids}{(\code{list})\cr list of direct children.}

\item{cont}{(\code{ElementaryTable})\cr content table.}

\item{lev}{(\code{integer(1)})\cr nesting level (roughly, indentation level in practical terms).}

\item{iscontent}{(\code{flag})\cr whether the \code{TableTree}/\code{ElementaryTable} is being constructed as the content
table for another \code{TableTree}.}

\item{cinfo}{(\code{InstantiatedColumnInfo} or \code{NULL})\cr column structure for the object being created.}

\item{labelrow}{(\code{LabelRow})\cr the \code{LabelRow} object to assign to the table. Constructed from \code{label} by default
if not specified.}

\item{vals}{(\code{list})\cr cell values for the row.}

\item{cspan}{(\code{integer})\cr column span. \code{1} indicates no spanning.}

\item{label_pos}{(\code{string})\cr location where the variable label should be displayed. Accepts \code{"hidden"}
(default for non-analyze row splits), \code{"visible"}, \code{"topleft"}, and \code{"default"} (for analyze splits only). For
\code{analyze} calls, \code{"default"} indicates that the variable should be visible if and only if multiple variables are
analyzed at the same level of nesting.}

\item{cindent_mod}{(\code{numeric(1)})\cr the indent modifier for the content tables generated by this split.}

\item{cvar}{(\code{string})\cr the variable, if any, that the content function should accept. Defaults to \code{NA}.}

\item{label}{(\code{string})\cr a label (not to be confused with the name) for the object/structure.}

\item{cextra_args}{(\code{list})\cr extra arguments to be passed to the content function when tabulating row group
summaries.}

\item{child_names}{(\code{character})\cr names to be given to the subsplits contained by a compound split (typically
an \code{AnalyzeMultiVars} split object).}

\item{title}{(\code{string})\cr single string to use as main title (\code{\link[formatters:title_footer]{formatters::main_title()}}). Ignored for subtables.}

\item{subtitles}{(\code{character})\cr a vector of strings to use as subtitles (\code{\link[formatters:title_footer]{formatters::subtitles()}}), where every
element is printed on a separate line. Ignored for subtables.}

\item{main_footer}{(\code{character})\cr a vector of strings to use as main global (non-referential) footer materials
(\code{\link[formatters:title_footer]{formatters::main_footer()}}), where every element is printed on a separate line.}

\item{prov_footer}{(\code{character})\cr a vector of strings to use as provenance-related global footer materials
(\code{\link[formatters:title_footer]{formatters::prov_footer()}}), where every element is printed on a separate line.}

\item{footnotes}{(\code{list} or \code{NULL})\cr referential footnotes to be applied at current level. In post-processing,
this can be achieved with \code{\link{fnotes_at_path<-}}.}

\item{page_title}{(\code{character})\cr page-specific title(s).}

\item{page_prefix}{(\code{string})\cr prefix to be appended with the split value when forcing pagination between
the children of a split/table.}

\item{section_div}{(\code{string})\cr string which should be repeated as a section divider after each group defined
by this split instruction, or \code{NA_character_} (the default) for no section divider.}

\item{trailing_section_div}{(\code{string})\cr string which will be used as a section divider after the printing
of the last row contained in this (sub)table, unless that row is also the last table row to be printed overall,
or \code{NA_character_} for none (the default). When generated via layouting, this would correspond to the
\code{section_div} of the split under which this table represents a single facet.}

\item{split_na_str}{(\code{character})\cr NA string vector for use with \code{split_format}.}

\item{cna_str}{(\code{character})\cr NA string for use with \code{cformat} for content table.}

\item{inset}{(\code{numeric(1)})\cr number of spaces to inset the table header, table body, referential footnotes, and
main_footer, as compared to alignment of title, subtitle, and provenance footer. Defaults to 0 (no inset).}

\item{table_inset}{(\code{numeric(1)})\cr number of spaces to inset the table header, table body, referential footnotes,
and main footer, as compared to alignment of title, subtitles, and provenance footer. Defaults to 0 (no inset).}

\item{header_section_div}{(\code{string})\cr string which will be used to divide the header from the table. See
\code{\link[=header_section_div]{header_section_div()}} for the associated getter and setter. Please consider changing last element of
\code{\link[=section_div]{section_div()}} when concatenating tables that require a divider between them.}
}
\value{
No return value.
}
\description{
Constructor argument conventions
}
\seealso{
Other conventions: 
\code{\link{compat_args}()},
\code{\link{gen_args}()},
\code{\link{lyt_args}()},
\code{\link{sf_args}()}
}
\concept{conventions}
\keyword{internal}
