% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_accessors.R
\docType{methods}
\name{section_div}
\alias{section_div}
\alias{section_div,VTableTree-method}
\alias{section_div,list-method}
\alias{section_div,TableRow-method}
\alias{section_div<-}
\alias{section_div<-,VTableTree-method}
\alias{section_div<-,list-method}
\alias{section_div<-,TableRow-method}
\alias{section_div<-,LabelRow-method}
\alias{header_section_div}
\alias{header_section_div,PreDataTableLayouts-method}
\alias{header_section_div,VTableTree-method}
\alias{header_section_div<-}
\alias{header_section_div<-,PreDataTableLayouts-method}
\alias{header_section_div<-,VTableTree-method}
\alias{top_level_section_div}
\alias{top_level_section_div,PreDataTableLayouts-method}
\alias{top_level_section_div<-}
\alias{top_level_section_div<-,PreDataTableLayouts-method}
\title{Section dividers accessor and setter}
\usage{
section_div(obj)

\S4method{section_div}{VTableTree}(obj)

\S4method{section_div}{list}(obj)

\S4method{section_div}{TableRow}(obj)

section_div(obj, only_sep_sections = FALSE) <- value

\S4method{section_div}{VTableTree}(obj, only_sep_sections = FALSE) <- value

\S4method{section_div}{list}(obj, only_sep_sections = FALSE) <- value

\S4method{section_div}{TableRow}(obj, only_sep_sections = FALSE) <- value

\S4method{section_div}{LabelRow}(obj, only_sep_sections = FALSE) <- value

header_section_div(obj)

\S4method{header_section_div}{PreDataTableLayouts}(obj)

\S4method{header_section_div}{VTableTree}(obj)

header_section_div(obj) <- value

\S4method{header_section_div}{PreDataTableLayouts}(obj) <- value

\S4method{header_section_div}{VTableTree}(obj) <- value

top_level_section_div(obj)

\S4method{top_level_section_div}{PreDataTableLayouts}(obj)

top_level_section_div(obj) <- value

\S4method{top_level_section_div}{PreDataTableLayouts}(obj) <- value
}
\arguments{
\item{obj}{(\code{VTableTree})\cr table object. This can be of any class that inherits from \code{VTableTree}
or \code{TableRow}/\code{LabelRow}.}

\item{only_sep_sections}{(\code{flag})\cr defaults to \code{FALSE} for \verb{section_div<-}. Allows
you to set the section divider only for sections that are splits or analyses if the number of
values is less than the number of rows in the table. If \code{TRUE}, the section divider will
be set for all rows of the table.}

\item{value}{(\code{character})\cr vector of single characters to use as section dividers. Each character
is repeated such that all section dividers span the width of the table. Each character that is
not \code{NA_character_} will produce a trailing separator for each row of the table. \code{value} length
should reflect the number of rows, or be between 1 and the number of splits/levels.
See the Details section below for more information.}
}
\value{
The section divider string. Each line that does not have a trailing separator
will have \code{NA_character_} as section divider.
}
\description{
\code{section_div} can be used to set or get the section divider for a table object
produced by \code{\link[=build_table]{build_table()}}. When assigned in post-processing (\verb{section_div<-})
the table can have a section divider after every row, each assigned independently.
If assigning during layout creation, only \code{\link[=split_rows_by]{split_rows_by()}} (and its related row-wise
splits) and \code{\link[=analyze]{analyze()}} have a \code{section_div} parameter that will produce separators
between split sections and data subgroups, respectively.
}
\details{
Assigned value to section divider must be a character vector. If any value is \code{NA_character_}
the section divider will be absent for that row or section. When you want to only affect sections
or splits, please use \code{only_sep_sections} or provide a shorter vector than the number of rows.
Ideally, the length of the vector should be less than the number of splits with, eventually, the
leaf-level, i.e. \code{DataRow} where analyze results are. Note that if only one value is inserted,
only the first split will be affected.
If \code{only_sep_sections = TRUE}, which is the default for \code{section_div()} produced from the table
construction, the section divider will be set for all the splits and eventually analyses, but
not for the header or each row of the table. This can be set with \code{header_section_div} in
\code{\link[=basic_table]{basic_table()}} or, eventually, with \code{hsep} in \code{\link[=build_table]{build_table()}}. If \code{FALSE}, the section
divider will be set for all the rows of the table.
}
\examples{
# Data
df <- data.frame(
  cat = c(
    "really long thing its so ", "long"
  ),
  value = c(6, 3, 10, 1)
)
fast_afun <- function(x) list("m" = rcell(mean(x), format = "xx."), "m/2" = max(x) / 2)

tbl <- basic_table() \%>\%
  split_rows_by("cat", section_div = "~") \%>\%
  analyze("value", afun = fast_afun, section_div = " ") \%>\%
  build_table(df)

# Getter
section_div(tbl)

# Setter
section_div(tbl) <- letters[seq_len(nrow(tbl))]
tbl

# last letter can appear if there is another table
rbind(tbl, tbl)

# header_section_div
header_section_div(tbl) <- "+"
tbl

}
\seealso{
\code{\link[=basic_table]{basic_table()}} parameter \code{header_section_div} and \code{top_level_section_div} for global
section dividers.
}
