#' Statistics in Medicine format.
#'
#' Format for creating submissions to Statistics in Medicine. Based on the official Statistics in Medicine
#' \href{http://onlinelibrary.wiley.com/journal/10.1002/(ISSN)1097-0258/homepage/la_tex_class_file.htm}{class}.
#'
#' @inheritParams rmarkdown::pdf_document
#' @param ... Additional arguments to \code{rmarkdown::pdf_document}
#'
#' @return R Markdown output format to pass to
#'   \code{\link[rmarkdown:render]{render}}
#'
#' @details Possible arguments for the YAML header are:
#' \itemize{
#'   \item \code{title} title of the manuscript
#'   \item \code{author} list of authors, containing \code{name} and \code{num}
#'   \item \code{address} list containing \code{num} and \code{org} for defining \code{author} affiliations
#'   \item \code{presentaddress} not sure what they mean with this
#'   \item \code{corres} author and address for correspondence
#'   \item \code{authormark} short author list for header
#'   \item \code{received}, \code{revised}, \code{accepted} dates of submission, revision, and acceptance of the manuscript
#'   \item \code{abstract} abstract, limited to 250 words
#'   \item \code{keywords} up to 6 keywords
#'   \item \code{bibliography} BibTeX \code{.bib} file
#'   \item \code{classoption} options of the \code{WileyNJD-v2} class
#'   \item \code{longtable} set to \code{true} to include the \code{longtable} package, used by default from \code{pandoc} to convert markdown to LaTeX code
#'  \item \code{header-includes}: custom additions to the header, before the \code{\\begin\{document\}} statement
#'  \item \code{include-after}: for including additional LaTeX code before the \code{\\end\{document\}} statement}
#'
#' @examples
#'
#' \dontrun{
#' library(rmarkdown)
#' draft("MyArticle.Rmd", template = "sim_article", package = "rticles")
#' }
#'
#' @export
sim_article <- function(..., highlight = NULL, citation_package = "natbib") {
  inherit_pdf_document(...,
                       template = find_resource("sim_article", "template.tex"),
                       highlight = highlight,
                       citation_package = citation_package)
}
