% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{transform_coord}
\alias{transform_coord}
\title{Transform the coordinates of spline data}
\usage{
transform_coord(
  data,
  to = "polar",
  origin = NULL,
  fan_lines = c(10, 25),
  use_XY = FALSE
)
}
\arguments{
\item{data}{A data set containing the spline coordinates (cartesian coordinates must be in columns named \code{X} and \code{Y}, polar coordinates in columns named \code{angle} and \code{radius}; these are the defaults in data imported with \code{read_aaa()}).}

\item{to}{Which system to convert to, as a string, either \code{"polar"} or \code{"cartesian"} (the default is \code{"polar"}).}

\item{origin}{The coordinates of the origin as a vector of \code{c(x, y)} coordinates.}

\item{fan_lines}{A numeric vector with two fan lines (the default is
\code{c(10, 25)}).}

\item{use_XY}{Whether to use the column names \code{X} and \code{Y} when converting to and from polar coordinates, rather than the default \code{angle} and \code{radius} (the default is \code{FALSE}. If \code{TRUE}, the columns \code{X} and \code{Y} are overwritten with the converted values. If converting to polar, \code{X} is the \code{angle} and \code{Y} the \code{radius}.}
}
\value{
An object of class \code{\link[tibble]{tbl_df-class}} (a tibble).
}
\description{
This function transforms the coordinates of spline data between Cartesian and
polar coordinate systems. The origin x and y coordinates can be supplied by
the user, or calculated automatically (see Details).
}
\details{
The transformation between the coordinate systems require the selection of an
origin in Cartesian coordinates (x and y). The origin ideally corresponds to
the virtual origin of the ultrasound waves from the probe. The origin
coordinates can be supplied by the user as a vector with the \code{origin}
argument, or they can be estimated automatically if \code{origin = NULL} (the
default). The estimation is performed by \code{\link{get_origin}} (see that
function documentation for details).
}
