% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clo.R
\name{indivCloCompare}
\alias{indivCloCompare}
\title{Compares model fit for the uncoupled and coupled oscillator for each dyad's state trajectories using an R-square comparison.}
\usage{
indivCloCompare(derivData)
}
\arguments{
\item{derivData}{A dataframe that was produced with the "estDerivs" function.
#' @examples
data <- rties_ExampleDataShort
newData <- dataPrep(basedata=data, dyadId="couple", personId="person", 
obs_name="dial", dist_name="female", time_name="time")
taus <-c(2,3)
embeds <- c(3,4)
delta <- 1
derivs <- estDerivs(prepData=newData, taus=taus, embeds=embeds, delta=delta, idConvention=500)
compare <- indivCloCompare(derivData=derivs$data)
summary(compare$R2couple)}
}
\value{
The function returns a named list including: 1) the adjusted R^2 for the uncoupled model for each dyad (called "R2uncouple"), 2) the adjusted R^2 for the coupled model for each dyad (called "R2couple"), and 3) the difference between the R-squares for each dyad (coupled - uncoupled, called "R2dif").
}
\description{
Fits an uncoupled and coupled oscillator model to each dyad's observed state variables and returns the adjusted R-squares, along with the difference between them (coupled - uncoupled, so positive values indicate better fit for the more complex model).
}
