% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/as_search.R
\name{as_search}
\alias{as_search}
\title{Search articles}
\usage{
as_search(q, fq = NULL, sort = NULL, begin_date = NULL, end_date = NULL,
  key = NULL, fl = NULL, hl = FALSE, page = 0, facet_field = NULL,
  facet_filter = NULL, ..., callopts = list())
}
\arguments{
\item{q}{Search query term. Search is performed on the article body, headline
and byline.}

\item{fq}{Filtered search query using standard Lucene syntax. The filter query
can be specified with or without a limiting field: label. See fq_fields for the
filter query fields.}

\item{sort}{(character) Default NULL. One of newest or oldest . By default, search
results are sorted by their relevance to the query term (q). Use the sort parameter
to sort by pub_date.}

\item{begin_date}{Begin date - Restricts responses to results with publication
dates of the date specified or later. In the form YYYYMMDD}

\item{end_date}{End date - Restricts responses to results with publication dates
of the date specified or earlier. In the form YYYYMMDD}

\item{key}{your New York Times API key; pass in, or loads from .Rprofile as
\code{nytimes_as_key}, or from .Renviron as \code{NYTIMES_AS_KEY}}

\item{fl}{Fields to get back, as vector. See Details for the.}

\item{hl}{(logical) Highlight or not, default is FALSE}

\item{page}{Page number. The value of page corresponds to a set of 10 results
(it does not indicate the starting number of the result set). For example, page=0
corresponds to records 0-9. To return records 10-19, set page to 1, not 10.}

\item{facet_field}{(character) Specifies the sets of facet values to include in the
facets array at the end of response, which collects the facet values from all the
search results. By default no facet fields will be returned. See details for options.}

\item{facet_filter}{(logical) Fields to facet on, as vector. When set to true,
facet counts will respect any applied filters (fq, date range, etc.) in addition to
the main query term. To filter facet counts, specifying at least one facet_field
is required.}

\item{...}{Futher args pass into query}

\item{callopts}{Curl options (debugging tools mostly) passed to \code{\link[httr]{GET}}}
}
\description{
Search articles
}
\details{
fl parameter options are: web_url, snippet, lead_paragraph, abstract, print_page,
blog, source, multimedia, headline, keywords, pub_date, document_type, news_desk,
byline, type_of_material, _id, word_count.

facet_field param options are: section_name, document_type, type_of_material,
source, day_of_week
}
\examples{
\dontrun{
as_search(q="bailout", begin_date = "20081001", end_date = '20081201')
as_search(q="bailout", facet_field = 'section_name', begin_date = "20081001",
   end_date = '20081201', fl = 'word_count')
as_search(q="money", fq = 'The New York Times')
as_search(q="money", fq = 'news_desk:("Sports" "Foreign")')
as_search(q="bailout", hl = TRUE)

library('httr')
as_search("iowa caucus", callopts = verbose())
}
}
\references{
\url{http://developer.nytimes.com/docs/article_search_api/}
}

