% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cf_candidate_state.R
\name{cf_candidate_state}
\alias{cf_candidate_state}
\title{Campaign finance - candidates from a state}
\usage{
cf_candidate_state(campaign_cycle, state, chamber = NULL, district = NULL,
  key = NULL, ...)
}
\arguments{
\item{campaign_cycle}{An even-numbdered year in YYYY format. Presidential data:
2008-present; Congressional data: 2000-present}

\item{state}{(character) Two-letter state abbreviation. required.}

\item{chamber}{(character) house or senate. required.}

\item{district}{(character) Specify the district number. Use 1 for states
with a single representative. (House requests only - districts with
Senate requests will be ignored.). required.}

\item{key}{(character) your Propublica API key; pass in, or loads from .Renviron as 
\code{PROPUBLICA_API_KEY}. See \code{\link{rtimes-package}} for info on rate limits.}

\item{...}{Curl options (debugging tools mostly) passed to 
\code{\link[crul]{HttpClient}}}
}
\description{
Campaign finance - candidates from a state
}
\examples{
\dontrun{
cf_candidate_state(campaign_cycle = 2014, state = "TX")
cf_candidate_state(campaign_cycle = 2012, state = "NM")
cf_candidate_state(campaign_cycle = 2016, state = "OR", chamber = "senate")
cf_candidate_state(campaign_cycle = 2016, state = "CA", 
  chamber = "house", district = 2)
}
}
\references{
\url{http://propublica.github.io/campaign-finance-api-docs}
}
\seealso{
Other campaign-finance: \code{\link{cf_candidate_details}},
  \code{\link{cf_candidate_leaders}},
  \code{\link{cf_candidate_new}},
  \code{\link{cf_candidate_search}}
}
