% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OmegaTIP.R
\name{OmegaTIP}
\alias{OmegaTIP}
\title{Matrix for testing TIP dominance}
\usage{
OmegaTIP(dataset, ipuc = "ipuc", hhcsw = "DB090", hhsize = "HX040",
  arpt.value = NULL, samplesize = 50, norm = FALSE)
}
\arguments{
\item{dataset}{a data.frame containing the variables.}

\item{ipuc}{a character string indicating the variable name of the income per unit of consumption. Default is "ipuc".}

\item{hhcsw}{a character string indicating the variable name of the household cross-sectional weight. Default is "DB090".}

\item{hhsize}{a character string indicating the variable name of the household size. Default is "HX040".}

\item{arpt.value}{the at-risk-of-poverty threshold to be used (see arpt). Default is NULL which calculates arpt with default parameters.}

\item{samplesize}{an integer which represents the number of TIP curve ordinates to be estimated. These ordinates will be estimated at points \eqn{p_i}, where \eqn{p_i=i/samplesize, i=1, \dots, samplesize}. Default is 50.}

\item{norm}{logical; if  TRUE, the normalised TIP curve ordinates are computed using the normalised poverty gaps (poverty gaps divided by the poverty threshold).}
}
\value{
A list with the following components:
\itemize{
\item Omega, covariance matrix for the estimated vector of TIP curve ordinates.
\item tip.curve estimated vector of TIP curve ordinates.
}
}
\description{
The auxiliary function OmegaTIP computes the (empirical) vector
of TIP curve ordinates and its corresponding covariance matrix.
Given two income distributions, this matrix will be used to test the
null hypothesis that one distribution dominates the other in the TIP sense.
}
\details{
Estimation of TIP curve ordinates and their covariance matrix are made following Beach and Davidson (1983), Beach and Kaliski (1986) and Xu and Osberg (1998).

Calculations are made using the equivalised disposable income. The equivalence scales that can be employed are the modified OECD scale or the parametric scale of Buhmann et al. (1988). The default is the modified OECD scale (see setupDataset).
}
\references{
C. M. Beach and R. Davidson (1983) Distribution-free statistical inference with Lorenz curves and income shares, Review of Economic Studies, 50, 723--735.

C. M. Beach and S. F. Kaliski (1986) Curve inference with sample weights: and application to the distribution of unemployment experience, Journal of the Royal Statistical Society. Series C (Applied Statistics), Vol. 35, No. 1, 38--45.

B. Buhmann et al. (1988) Equivalence scales, well-being, inequality and poverty: sensitivity estimates across ten countries using the Luxembourg Income Study (LIS) database, Review of Income and Wealth, 34, 115--142.

K. Xu and L. Osberg (1998) A distribution-free test for deprivation dominance, Econometric Reviews,17, 415--429.
}
\seealso{
testTIP, setupDataset, arpt
}
\author{
A. Berihuete, C.D. Ramos and M.A. Sordo
}
