% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timelines_statuses.R
\name{get_poll}
\alias{get_poll}
\title{View a poll}
\usage{
get_poll(id, instance = NULL, token = NULL, anonymous = FALSE, parse = TRUE)
}
\arguments{
\item{id}{character, ID of the poll in the database}

\item{instance}{character, the server name of the instance where the status is located. If \code{NULL}, the same instance used to obtain the token is used.}

\item{token}{user bearer token (read from file by default)}

\item{anonymous}{some API calls do not need a token. Setting anonymous to TRUE allows to make an anonymous call if possible.}

\item{parse}{logical, if \code{TRUE}, the default, returns a tibble. Use \code{FALSE}  to return the "raw" list corresponding to the JSON returned from the Mastodon API.}
}
\value{
a poll
}
\description{
View a polls attached to statuses. To discover poll ID, you will need to use \code{\link[=get_status]{get_status()}} and look into the \code{poll}.
}
\examples{
\dontrun{
get_poll(id = "105976")
}
}
