% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post.R
\name{post_user}
\alias{post_user}
\title{Perform actions on an account}
\usage{
post_user(id, action = "follow", comment = "", token = NULL, verbose = TRUE)
}
\arguments{
\item{id}{character, user id to perform the action on}

\item{action}{character, one of "(un)follow","(un)block", "(un)mute", "(un)pin","note"}

\item{comment}{character (if action="note"), The comment to be set on that user. Provide an empty string or leave out this parameter to clear the currently set note.}

\item{token}{user bearer token (read from file by default)}

\item{verbose}{logical whether to display messages}
}
\value{
no return value, called for site effects
}
\description{
Perform actions on an account
}
\examples{
\dontrun{
# follow a user
post_user("xxxxxx", action = "follow")
# unfollow a user
post_user("xxxxxx", action = "unfollow")
}
}
