% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/memory_alpha.R
\name{ma_article}
\alias{ma_article}
\title{Read Memory Alpha article}
\usage{
ma_article(
  url,
  content_format = c("xml", "character"),
  content_nodes = c("h2", "h3", "p", "b", "ul"),
  browse = FALSE
)
}
\arguments{
\item{url}{character, article URL. Expects package-style short URL. See examples.}

\item{content_format}{character, the format of the article main text, \code{"xml"} or \code{"character"}.}

\item{content_nodes}{character, which top-level nodes in the article main text to retain.}

\item{browse}{logical, also open \code{url} in browser.}
}
\value{
a nested data frame
}
\description{
Read Memory Alpha article content and metadata.
}
\details{
Article content is returned in a nested, tidy data frame.
}
\examples{
\donttest{ma_article("Azetbur")}
}
