% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_tcf.R
\name{read_tcf}
\alias{read_tcf}
\title{Read a TRIM command file}
\usage{
read_tcf(file, encoding = getOption("encoding"), simplify = TRUE)
}
\arguments{
\item{file}{Location of TRIM command file.}

\item{encoding}{The encoding in which the file is stored.}

\item{simplify}{Return a single \code{trimcommand} object if only one
model is specified in the TRIM command file.}
}
\value{
A trimcommand object, or in the case of multiple models in a single
TRIM command file, a \code{list} of \code{trimcommand} objects. In the
latter case, a useful summary can be printed with \code{\link{summary.trimbatch}}.
}
\description{
Read TRIM Command Files, compatible with the Windows TRIM programme.
}
\section{TRIM Command file format}{


TRIM command files are text files that specify a TRIM job, where a job
consists of one or more models to be computed on a single data input file.
TRIM command files are commonly stored with the extension \code{.tcf}, but
this is not a strict requirement.

A TRIM command file consists of two parts. The first part describes the
data file to be read, the second part describes the model(s) to be run. A
TRIM command file can only contain a single data specification part, but multiple
models may be specified.

Each command starts on a new line with a keyword, followed by at least
one space and at least one option value, where multiple option values are
separated by spaces. All commands must be written on a single line, except
the \code{LABELS} command (to set labels for covariates). The latter command
starts with \code{LABELS} on a single line, followed by a newline, followed
by a new label on each following line. The keyword \code{END} (at the beginning of a line)
signals the end of the labels command.

The keyword \code{RUN} (at the beginning of a single line) ends the
specification of a single model. After this a new model can be specified.
Parameters not specified in the current model will be copied from the previous
one.
}

\section{TRIM commands}{


The commands are identical to those in the original TRIM software. Commands
that represent a simple toggle (on/off, present/absent) are translated to a
\code{logical} upon reading. Below we give commands in upper case, but the
commands are parsed case insensitively.

\tabular{ll}{
\bold{Data}\tab\cr
\code{FILE}   \tab data filename and path.\cr
\code{TITLE}  \tab A title (appears in output when exported).\cr
\code{NTIMES} \tab [positive integer] Number of time points in data file.\cr
\code{NCOVARS}\tab [nonnegative integer] Number of covariates in data file.\cr
\code{LABELS} \tab Covariate labels (multiline command). \cr
\code{END}    \tab Signals end of \code{LABELS} command.\cr
\code{MISSING}\tab missing value indicator.\cr
\code{WEIGHT} \tab [\code{present}, \code{absent}] Indicates whether weights are present in the data file [translated to \code{logical}].\cr
\bold{Model}  \tab\cr
\code{COMMENT}  \tab A comment for the current model.\cr
\code{WEIGHTING}\tab [\code{on},\code{off}] Switch use of weights for current model [translated to \code{logical}].\cr
\code{SERIALCOR}\tab [\code{on},\code{off}] Switch use of serial correlation for current model [translated to \code{logical}].\cr
\code{OVERDISP}\tab [\code{on},\code{off}] Switch use of overdispersion for current model [translated to \code{logical}].\cr
\code{BASETIME}\tab [integer] Index of base time-point.\cr
\code{MODEL}\tab [\code{1}, \code{2}, \code{3}] Choose the current model\cr
\code{COVARIATES}\tab [integers] indices of covariates to use (1st covariate has index 1)\cr
\code{CHANGEPOINTS} \tab [integers] indices of changepoints\cr
\code{STEPWISE} \tab [\code{on},\code{off}] Switch stepwise selection of changepoints [translated to \code{logical}].\cr
\code{AUTODELETE} \tab [\code{on}, \code{off}] Delete changepoints when the corresponding time segment has to litte observations. \cr
\code{OVERALLCHANGEPOINTS} \tab[integers] indices of overall changepoints\cr
\code{RUN}\tab Signals end of current model specification.\cr
\bold{Output} \tab\cr
\code{IMPCOVOUT}\tab [\code{on}, \code{off}] Switch to save variance-covariance matrix \cr
\code{COVIN}\tab [\code{on}, \code{off}] Switch to read variance-covariance matrix
}
}

\section{Encoding issues}{


To read files containing non-ASCII characters encoded in a format that is not
native to your system, specifiy the \code{encoding} option. This causes R to
re-encode to native encoding upon reading. Input encodings supported for your
system can be listed by calling \code{\link[base]{iconvlist}()}. For more
information on Encoding in R, see \code{\link[base]{Encoding}}.
}

\section{Note on filenames}{


If the \code{file} is specified using backslashes to separate directories
(Windows style), this will be converted to a filename using forward slashes
(POSIX style, as used by R).
}
\seealso{
\href{../doc/Working_with_tcf.html}{Working with TRIM command files and TRIM data files}.

Other modelspec: \code{\link{check_observations}},
  \code{\link{read_tdf}}, \code{\link{set_trim_verbose}},
  \code{\link{trimcommand}}, \code{\link{trim}}
}

