% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_left.R
\name{rtry_join_left}
\alias{rtry_join_left}
\title{Left join for two data frames}
\usage{
rtry_join_left(x, y, baseOn, showOverview = TRUE)
}
\arguments{
\item{x}{A data frame or data table to be coerced and will be considered as the data on the left.}

\item{y}{A data frame or data table to be coerced and will be considered as the data on the right.}

\item{baseOn}{The common column used for merging.}

\item{showOverview}{Default \code{TRUE} displays the dimension and column names of the merged data.}
}
\value{
An object of the same type of the input data. The merged data is by default lexicographically sorted
on the common column. The columns are the common column followed by the remaining columns in
\code{x} and then those in \code{y}.
}
\description{
This function merges two data frames or data tables based on a specified common column and
returns all records from the left data frame (\code{x}) together with the matched records
from the right data frame (\code{y}), while discards all the records in the right data frame
that does not exist in the left data frame. In other words, this function performs a left join
on the two provided data frames or data tables.
}
\examples{
# Assume a user has obtained two unique data tables, one with the ancillary data
# Longitude and one with Latitude (e.g. using rtry_select_anc()), and would like to
# add a column Latitude to the data table with Longitude based on the common
# identifier ObservationID
lon <- rtry_select_anc(data_TRY_15160, 60)
lat <- rtry_select_anc(data_TRY_15160, 59)

georef <- rtry_join_left(lon, lat, baseOn = ObservationID)

# Expected messages:
# dim:   97 2
# col:   ObservationID Longitude
#
# dim:   98 2
# col:   ObservationID Latitude
#
# dim:   97 3
# col:   ObservationID Longitude Latitude
}
\references{
This function makes use of the \code{\link[base]{merge}} function
within the \code{base} package.
}
\seealso{
\code{\link{rtry_join_outer}}, \code{\link{rtry_bind_col}}, \code{\link{rtry_bind_row}}
}
